/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.MethodHandleEntry;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.Util;
import java.util.List;

public final class BootstrapMethodEntryImpl
implements BootstrapMethodEntry {
    final int index;
    final int hash;
    private final ConstantPool constantPool;
    private final AbstractPoolEntry.MethodHandleEntryImpl handle;
    private final List<LoadableConstantEntry> arguments;

    BootstrapMethodEntryImpl(ConstantPool constantPool, int bsmIndex, int hash, AbstractPoolEntry.MethodHandleEntryImpl handle, List<LoadableConstantEntry> arguments) {
        this.index = bsmIndex;
        this.hash = hash;
        this.constantPool = constantPool;
        this.handle = handle;
        this.arguments = Util.sanitizeU2List(arguments);
    }

    @Override
    public ConstantPool constantPool() {
        return this.constantPool;
    }

    @Override
    public MethodHandleEntry bootstrapMethod() {
        return this.handle;
    }

    @Override
    public List<LoadableConstantEntry> arguments() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        BootstrapMethodEntry e;
        return obj instanceof BootstrapMethodEntry && (e = (BootstrapMethodEntry)obj).bootstrapMethod().equals(this.handle) && e.arguments().equals(this.arguments);
    }

    static int computeHashCode(AbstractPoolEntry.MethodHandleEntryImpl handle, List<? extends LoadableConstantEntry> arguments) {
        return 31 * handle.hashCode() + arguments.hashCode() | 0x40000000;
    }

    @Override
    public int bsmIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hash;
    }

    void writeTo(BufWriterImpl writer) {
        writer.writeIndex(this.bootstrapMethod());
        Util.writeListIndices(writer, this.arguments());
    }
}

