/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.components;

import io.smallrye.classfile.AccessFlags;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.TypeKind;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.CodeLocalsShifterImpl;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CodeLocalsShifter
extends CodeTransform {
    public static CodeLocalsShifter of(AccessFlags methodFlags, MethodTypeDesc methodDescriptor) {
        int fixed = methodFlags.has(AccessFlag.STATIC) ? 0 : 1;
        for (ClassDesc param : methodDescriptor.parameterList()) {
            fixed += TypeKind.from(param).slotSize();
        }
        return new CodeLocalsShifterImpl(fixed);
    }
}

