/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.ClassSignature;
import io.smallrye.classfile.FieldElement;
import io.smallrye.classfile.MethodElement;
import io.smallrye.classfile.MethodSignature;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface SignatureAttribute
extends Attribute<SignatureAttribute>,
ClassElement,
MethodElement,
FieldElement {
    public Utf8Entry signature();

    default public ClassSignature asClassSignature() {
        return ClassSignature.parseFrom(this.signature().stringValue());
    }

    default public MethodSignature asMethodSignature() {
        return MethodSignature.parseFrom(this.signature().stringValue());
    }

    default public Signature asTypeSignature() {
        return Signature.parseFrom(this.signature().stringValue());
    }

    public static SignatureAttribute of(ClassSignature classSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(classSignature.signatureString()));
    }

    public static SignatureAttribute of(MethodSignature methodSignature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(methodSignature.signatureString()));
    }

    public static SignatureAttribute of(Signature signature) {
        return SignatureAttribute.of(TemporaryConstantPool.INSTANCE.utf8Entry(signature.signatureString()));
    }

    public static SignatureAttribute of(Utf8Entry signature) {
        return new UnboundAttribute.UnboundSignatureAttribute(signature);
    }
}

