/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.AttributedElement;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RecordComponentInfo
extends AttributedElement {
    public Utf8Entry name();

    public Utf8Entry descriptor();

    default public ClassDesc descriptorSymbol() {
        return Util.fieldTypeSymbol(this.descriptor());
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(name, descriptor, attributes);
    }

    public static RecordComponentInfo of(Utf8Entry name, Utf8Entry descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, List<Attribute<?>> attributes) {
        return new UnboundAttribute.UnboundRecordComponentInfo(TemporaryConstantPool.INSTANCE.utf8Entry(name), TemporaryConstantPool.INSTANCE.utf8Entry(descriptor), attributes);
    }

    public static RecordComponentInfo of(String name, ClassDesc descriptor, Attribute<?> ... attributes) {
        return RecordComponentInfo.of(name, descriptor, List.of(attributes));
    }
}

