/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.extras.constant.ModuleDesc;
import io.smallrye.classfile.extras.constant.PackageDesc;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModuleExportInfo {
    public PackageEntry exportedPackage();

    public int exportsFlagsMask();

    default public Set<AccessFlag> exportsFlags() {
        return AccessFlag.maskToAccessFlags(this.exportsFlagsMask(), AccessFlag.Location.MODULE_EXPORTS);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.MODULE_EXPORTS, this.exportsFlagsMask(), flag);
    }

    public List<ModuleEntry> exportsTo();

    public static ModuleExportInfo of(PackageEntry exports, int exportFlags, List<ModuleEntry> exportsTo) {
        return new UnboundAttribute.UnboundModuleExportInfo(exports, exportFlags, exportsTo);
    }

    public static ModuleExportInfo of(PackageEntry exports, Collection<AccessFlag> exportFlags, List<ModuleEntry> exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageEntry exports, int exportFlags, ModuleEntry ... exportsTo) {
        return ModuleExportInfo.of(exports, exportFlags, List.of(exportsTo));
    }

    public static ModuleExportInfo of(PackageEntry exports, Collection<AccessFlag> exportFlags, ModuleEntry ... exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageDesc exports, int exportFlags, List<ModuleDesc> exportsTo) {
        return ModuleExportInfo.of(TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(exports.internalName())), exportFlags, Util.moduleEntryList(exportsTo));
    }

    public static ModuleExportInfo of(PackageDesc exports, Collection<AccessFlag> exportFlags, List<ModuleDesc> exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }

    public static ModuleExportInfo of(PackageDesc exports, int exportFlags, ModuleDesc ... exportsTo) {
        return ModuleExportInfo.of(exports, exportFlags, List.of(exportsTo));
    }

    public static ModuleExportInfo of(PackageDesc exports, Collection<AccessFlag> exportFlags, ModuleDesc ... exportsTo) {
        return ModuleExportInfo.of(exports, Util.flagsToBits(AccessFlag.Location.MODULE_EXPORTS, exportFlags), exportsTo);
    }
}

