/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.util.Optional;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InnerClassInfo {
    public ClassEntry innerClass();

    public Optional<ClassEntry> outerClass();

    public Optional<Utf8Entry> innerName();

    public int flagsMask();

    default public Set<AccessFlag> flags() {
        return AccessFlag.maskToAccessFlags(this.flagsMask(), AccessFlag.Location.INNER_CLASS);
    }

    default public boolean has(AccessFlag flag) {
        return Util.has(AccessFlag.Location.INNER_CLASS, this.flagsMask(), flag);
    }

    public static InnerClassInfo of(ClassEntry innerClass, Optional<ClassEntry> outerClass, Optional<Utf8Entry> innerName, int flags) {
        return new UnboundAttribute.UnboundInnerClassInfo(innerClass, outerClass, innerName, flags);
    }

    public static InnerClassInfo of(ClassDesc innerClass, Optional<ClassDesc> outerClass, Optional<String> innerName, int flags) {
        return new UnboundAttribute.UnboundInnerClassInfo(TemporaryConstantPool.INSTANCE.classEntry(innerClass), outerClass.map(TemporaryConstantPool.INSTANCE::classEntry), innerName.map(TemporaryConstantPool.INSTANCE::utf8Entry), flags);
    }

    public static InnerClassInfo of(ClassDesc innerClass, Optional<ClassDesc> outerClass, Optional<String> innerName, AccessFlag ... flags) {
        return InnerClassInfo.of(innerClass, outerClass, innerName, Util.flagsToBits(AccessFlag.Location.INNER_CLASS, flags));
    }
}

