/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jaxrs;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.jboss.resteasy.reactive.common.util.CaseInsensitiveMap;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.jaxrs.AbstractInterceptorContext;

public class WriterInterceptorContextImpl
extends AbstractInterceptorContext
implements WriterInterceptorContext {
    private final WriterInterceptor[] interceptors;
    private final MessageBodyWriter writer;
    private final MultivaluedMap<String, Object> headers = new CaseInsensitiveMap();
    private Object entity;
    boolean done = false;
    private int index = 0;

    public WriterInterceptorContextImpl(ResteasyReactiveRequestContext context, WriterInterceptor[] interceptors, MessageBodyWriter<?> writer, Annotation[] annotations, Class<?> type, Type genericType, Object entity, MediaType mediaType, MultivaluedMap<String, Object> headers, ServerSerialisers serialisers) {
        super(context, annotations, type, genericType, mediaType, serialisers);
        this.interceptors = interceptors;
        this.writer = writer;
        this.entity = entity;
        this.headers.putAll(headers);
    }

    public void proceed() throws IOException, WebApplicationException {
        Response response = this.context.getResponse().get();
        this.context.serverResponse().setPreCommitListener(null);
        if (this.index == this.interceptors.length) {
            MessageBodyWriter effectiveWriter = this.writer;
            if (this.rediscoveryNeeded) {
                List newWriters = this.serialisers.findWriters(null, this.entity.getClass(), this.mediaType, RuntimeType.SERVER);
                if (newWriters.isEmpty()) {
                    throw new InternalServerErrorException("Could not find MessageBodyWriter for " + String.valueOf(this.entity.getClass()), Response.serverError().build());
                }
                effectiveWriter = (MessageBodyWriter)newWriters.get(0);
            }
            this.context.setResult(Response.fromResponse((Response)response).replaceAll(this.headers).build());
            ServerSerialisers.encodeResponseHeaders(this.context);
            effectiveWriter.writeTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType != null ? this.mediaType : this.context.getResponseMediaType(), response.getHeaders(), this.context.getOrCreateOutputStream());
            this.context.getOutputStream().close();
            this.done = true;
        } else {
            this.interceptors[this.index++].aroundWriteTo((WriterInterceptorContext)this);
            if (!this.done) {
                this.context.setResult(Response.fromResponse((Response)response).replaceAll(this.headers).build());
                ServerSerialisers.encodeResponseHeaders(this.context);
                this.context.serverResponse().end();
            }
        }
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public OutputStream getOutputStream() {
        OutputStream existing = this.context.getOutputStream();
        if (existing != null) {
            return existing;
        }
        return this.context.getOrCreateOutputStream();
    }

    public void setOutputStream(OutputStream os) {
        this.context.setOutputStream(os);
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }
}

