/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.common.processor.scanning;

import java.util.Set;
import javax.ws.rs.core.Application;
import org.jboss.jandex.ClassInfo;
import org.jboss.resteasy.reactive.common.processor.BlockingDefault;
import org.jboss.resteasy.reactive.common.processor.ResteasyReactiveDotNames;

public final class ApplicationScanningResult {
    final Set<String> allowedClasses;
    final Set<String> singletonClasses;
    final Set<String> excludedClasses;
    final Set<String> globalNameBindings;
    final boolean filterClasses;
    final Application application;
    final ClassInfo selectedAppClass;
    final BlockingDefault blocking;

    public ApplicationScanningResult(Set<String> allowedClasses, Set<String> singletonClasses, Set<String> excludedClasses, Set<String> globalNameBindings, boolean filterClasses, Application application, ClassInfo selectedAppClass, BlockingDefault blocking) {
        this.allowedClasses = allowedClasses;
        this.singletonClasses = singletonClasses;
        this.excludedClasses = excludedClasses;
        this.globalNameBindings = globalNameBindings;
        this.filterClasses = filterClasses;
        this.application = application;
        this.selectedAppClass = selectedAppClass;
        this.blocking = blocking;
    }

    public KeepProviderResult keepProvider(ClassInfo providerClass) {
        if (this.filterClasses) {
            if (this.allowedClasses.isEmpty()) {
                if (this.excludedClasses.contains(providerClass.name().toString())) {
                    return KeepProviderResult.DISCARD;
                }
            } else {
                return this.allowedClasses.contains(providerClass.name().toString()) ? KeepProviderResult.SERVER_ONLY : KeepProviderResult.DISCARD;
            }
        }
        return providerClass.classAnnotation(ResteasyReactiveDotNames.PROVIDER) != null ? KeepProviderResult.NORMAL : KeepProviderResult.DISCARD;
    }

    public boolean keepClass(String className) {
        if (this.filterClasses) {
            if (this.allowedClasses.isEmpty()) {
                return !this.excludedClasses.contains(className);
            }
            return this.allowedClasses.contains(className);
        }
        return true;
    }

    public Set<String> getAllowedClasses() {
        return this.allowedClasses;
    }

    public Set<String> getExcludedClasses() {
        return this.excludedClasses;
    }

    public Set<String> getSingletonClasses() {
        return this.singletonClasses;
    }

    public Set<String> getGlobalNameBindings() {
        return this.globalNameBindings;
    }

    public boolean isFilterClasses() {
        return this.filterClasses;
    }

    public Application getApplication() {
        return this.application;
    }

    public ClassInfo getSelectedAppClass() {
        return this.selectedAppClass;
    }

    public BlockingDefault getBlockingDefault() {
        return this.blocking;
    }

    public static enum KeepProviderResult {
        NORMAL,
        SERVER_ONLY,
        DISCARD;

    }
}

