/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.reactive.server.spi;

import io.quarkus.builder.item.MultiBuildItem;
import org.jboss.resteasy.reactive.server.ExceptionUnwrapStrategy;

public final class UnwrappedExceptionBuildItem
extends MultiBuildItem {
    private final String throwableClassName;
    private final ExceptionUnwrapStrategy strategy;

    public UnwrappedExceptionBuildItem(String throwableClassName) {
        this(throwableClassName, ExceptionUnwrapStrategy.UNWRAP_IF_NO_MATCH);
    }

    public UnwrappedExceptionBuildItem(String throwableClassName, ExceptionUnwrapStrategy strategy) {
        this.throwableClassName = throwableClassName;
        this.strategy = strategy;
    }

    public UnwrappedExceptionBuildItem(Class<? extends Throwable> throwableClassName) {
        this(throwableClassName.getName(), ExceptionUnwrapStrategy.UNWRAP_IF_NO_MATCH);
    }

    public UnwrappedExceptionBuildItem(Class<? extends Throwable> throwableClassName, ExceptionUnwrapStrategy strategy) {
        this(throwableClassName.getName(), strategy);
    }

    @Deprecated(forRemoval=true)
    public Class<? extends Throwable> getThrowableClass() {
        try {
            return Class.forName(this.throwableClassName, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public String getThrowableClassName() {
        return this.throwableClassName;
    }

    public ExceptionUnwrapStrategy getStrategy() {
        return this.strategy;
    }
}

