/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.tracing.instrumentation.websockets;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.UrlAttributes;
import io.quarkus.websockets.next.runtime.spi.telemetry.EndpointKind;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketEndpointContext;
import io.quarkus.websockets.next.runtime.spi.telemetry.WebSocketTracesInterceptor;
import jakarta.enterprise.context.Dependent;
import java.util.Map;

@Dependent
public final class WebSocketTracesInterceptorImpl
implements WebSocketTracesInterceptor {
    public static final String CONNECTION_ID_ATTR_KEY = "connection.id";
    public static final String CONNECTION_ENDPOINT_ATTR_KEY = "connection.endpoint.id";
    public static final String CONNECTION_CLIENT_ATTR_KEY = "connection.client.id";
    private static final String CONNECTION_OPENED_SPAN_CTX = "io.quarkus.opentelemetry.ws.connection-opened-span-ctx";
    private final Tracer tracer;

    WebSocketTracesInterceptorImpl(Tracer tracer) {
        this.tracer = tracer;
    }

    public Map<String, Object> onConnectionOpened(String route, EndpointKind endpointKind) {
        Span span = this.tracer.spanBuilder("OPEN " + route).setSpanKind(WebSocketTracesInterceptorImpl.getSpanKind(endpointKind)).addLink(WebSocketTracesInterceptorImpl.previousSpanContext()).setAttribute(UrlAttributes.URL_PATH, (Object)route).startSpan();
        try {
            Map<String, SpanContext> map;
            block9: {
                Scope ignored = span.makeCurrent();
                try {
                    map = Map.of(CONNECTION_OPENED_SPAN_CTX, span.getSpanContext());
                    if (ignored == null) break block9;
                }
                catch (Throwable throwable) {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignored.close();
            }
            return map;
        }
        finally {
            span.end();
        }
    }

    public void onConnectionOpeningFailed(Throwable cause, String route, EndpointKind endpointKind, Map<String, Object> connectionOpenedContext) {
        this.tracer.spanBuilder("OPEN " + route).setSpanKind(WebSocketTracesInterceptorImpl.getSpanKind(endpointKind)).addLink(WebSocketTracesInterceptorImpl.getOnOpenSpanContext(connectionOpenedContext)).setAttribute(UrlAttributes.URL_PATH, (Object)route).startSpan().recordException(cause).end();
    }

    public void onConnectionClosed(WebSocketEndpointContext ctx) {
        this.tracer.spanBuilder("CLOSE " + ctx.route()).setSpanKind(WebSocketTracesInterceptorImpl.getSpanKind(ctx)).addLink(WebSocketTracesInterceptorImpl.getOnOpenSpanContext(ctx)).setAttribute(CONNECTION_ID_ATTR_KEY, ctx.connectionId()).setAttribute(UrlAttributes.URL_PATH, (Object)ctx.route()).setAttribute(WebSocketTracesInterceptorImpl.getTargetIdKey(ctx), ctx.targetId()).startSpan().end();
    }

    public void onConnectionClosingFailed(Throwable throwable, WebSocketEndpointContext ctx) {
        this.tracer.spanBuilder("CLOSE " + ctx.route()).setSpanKind(WebSocketTracesInterceptorImpl.getSpanKind(ctx)).addLink(WebSocketTracesInterceptorImpl.getOnOpenSpanContext(ctx)).setAttribute(CONNECTION_ID_ATTR_KEY, ctx.connectionId()).setAttribute(UrlAttributes.URL_PATH, (Object)ctx.route()).setAttribute(WebSocketTracesInterceptorImpl.getTargetIdKey(ctx), ctx.targetId()).startSpan().recordException(throwable).end();
    }

    private static SpanContext getOnOpenSpanContext(WebSocketEndpointContext ctx) {
        return WebSocketTracesInterceptorImpl.getOnOpenSpanContext(ctx.connectionContextStorage());
    }

    private static SpanContext getOnOpenSpanContext(Map<String, Object> connectionContextStorage) {
        if (connectionContextStorage == null) {
            return null;
        }
        return (SpanContext)connectionContextStorage.get(CONNECTION_OPENED_SPAN_CTX);
    }

    private static String getTargetIdKey(WebSocketEndpointContext ctx) {
        return WebSocketTracesInterceptorImpl.getTargetIdKey(ctx.endpointKind());
    }

    private static String getTargetIdKey(EndpointKind endpointKind) {
        return switch (endpointKind) {
            default -> throw new IncompatibleClassChangeError();
            case EndpointKind.CLIENT -> CONNECTION_CLIENT_ATTR_KEY;
            case EndpointKind.SERVER -> CONNECTION_ENDPOINT_ATTR_KEY;
        };
    }

    private static SpanKind getSpanKind(WebSocketEndpointContext context) {
        return WebSocketTracesInterceptorImpl.getSpanKind(context.endpointKind());
    }

    private static SpanKind getSpanKind(EndpointKind endpointKind) {
        return switch (endpointKind) {
            default -> throw new IncompatibleClassChangeError();
            case EndpointKind.CLIENT -> SpanKind.CLIENT;
            case EndpointKind.SERVER -> SpanKind.SERVER;
        };
    }

    private static SpanContext previousSpanContext() {
        Span span = Span.current();
        if (span.getSpanContext().isValid()) {
            return span.getSpanContext();
        }
        return null;
    }
}

