/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.RunningQuarkusApplication;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.runner.bootstrap.StartupActionImpl;
import io.quarkus.test.junit.AbstractQuarkusTestWithContextExtension;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.classloading.FacadeClassLoader;
import io.smallrye.config.SmallRyeConfig;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;

public class AbstractJvmQuarkusTestExtension
extends AbstractQuarkusTestWithContextExtension
implements ExecutionCondition {
    protected static final String TEST_LOCATION = "test-location";
    protected static final String TEST_CLASS = "test-class";
    protected static final String TEST_PROFILE = "test-profile";
    protected static RunningQuarkusApplication runningQuarkusApplication;
    protected static Class<? extends QuarkusTestProfile> quarkusTestProfile;
    protected static final Deque<Class<?>> currentTestClassStack;
    protected static Class<?> currentJUnitTestClass;
    private static final Logger log;

    public static Class<? extends QuarkusTestProfile> getQuarkusTestProfile(Class testClass, ExtensionContext extensionContext) {
        Class<? extends QuarkusTestProfile> testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation(testClass);
        if (testProfile != null) {
            return testProfile;
        }
        if (testClass.isAnnotationPresent(Nested.class)) {
            ExtensionContext currentExtensionContext;
            testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation(testClass.getEnclosingClass());
            if (testProfile != null) {
                return testProfile;
            }
            Optional parentContext = extensionContext.getParent();
            while (parentContext.isPresent() && !(currentExtensionContext = (ExtensionContext)parentContext.get()).getTestClass().isEmpty()) {
                testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation((Class)currentExtensionContext.getTestClass().get());
                if (testProfile != null) {
                    return testProfile;
                }
                parentContext = currentExtensionContext.getParent();
            }
        }
        return null;
    }

    protected Class<? extends QuarkusTestProfile> getQuarkusTestProfile(ExtensionContext extensionContext) {
        Class testClass = extensionContext.getRequiredTestClass();
        Class<? extends QuarkusTestProfile> testProfile = AbstractJvmQuarkusTestExtension.getQuarkusTestProfile(testClass, extensionContext);
        if (testProfile != null) {
            return testProfile;
        }
        if (testClass.isAnnotationPresent(Nested.class)) {
            ExtensionContext currentExtensionContext;
            Optional parentContext = extensionContext.getParent();
            while (parentContext.isPresent() && !(currentExtensionContext = (ExtensionContext)parentContext.get()).getTestClass().isEmpty()) {
                testProfile = AbstractJvmQuarkusTestExtension.findTestProfileAnnotation((Class)currentExtensionContext.getTestClass().get());
                if (testProfile != null) {
                    return testProfile;
                }
                parentContext = currentExtensionContext.getParent();
            }
        }
        return null;
    }

    private static Class<? extends QuarkusTestProfile> findTestProfileAnnotation(Class<?> clazz) {
        for (Class<?> testClass = clazz; testClass != null; testClass = testClass.getEnclosingClass()) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation == null) continue;
            return annotation.value();
        }
        return null;
    }

    protected boolean isNewApplication(QuarkusTestExtensionState state, Class<?> currentJUnitTestClass) {
        return runningQuarkusApplication == null || runningQuarkusApplication.getClassLoader() != currentJUnitTestClass.getClassLoader();
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        QuarkusTestProfile profileInstance;
        TestConfig testConfig;
        if (!context.getTestClass().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"No test class specified");
        }
        if (context.getTestInstance().isPresent()) {
            return ConditionEvaluationResult.enabled((String)"Quarkus Test Profile tags only affect classes");
        }
        boolean isFlatClasspath = this.getClass().getClassLoader() == ClassLoader.getSystemClassLoader();
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        if (!isFlatClasspath && !(original instanceof FacadeClassLoader)) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        try {
            testConfig = (TestConfig)((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getConfigMapping(TestConfig.class);
        }
        catch (Exception | ServiceConfigurationError e) {
            boolean isMaybeVSCode;
            String javaCommand = System.getProperty("sun.java.command");
            boolean isEclipse = javaCommand != null && javaCommand.contains("JUnit5TestLoader");
            boolean isVSCode = isEclipse && System.getProperty("java.class.path").contains("vscode");
            boolean bl = isMaybeVSCode = isEclipse && javaCommand.contains("testNames") && javaCommand.contains("testNameFile");
            if (isVSCode) {
                log.error((Object)"Could not read configuration while evaluating whether to run a test. This is a known issue when running tests in the VS Code IDE. To work around the problem, run individual test methods.");
            } else if (isMaybeVSCode) {
                log.error((Object)"Could not read configuration while evaluating whether to run a test. It looks like you're probably running tests with VS Code. This is a known issue when running tests in the VS Code IDE. To work around the problem, run individual test methods.");
            } else if (isEclipse) {
                log.error((Object)("Could not read configuration while evaluating whether to run a test. This is a known issue when running tests in older versions of the Eclipse IDE. Please upgrade to at least version 2025-09. Alternatively, to work around the problem, edit the run configuration and add `-uniqueId [engine:junit-jupiter]/[class:" + context.getRequiredTestClass().getName() + "]` in the program arguments. Running the whole package, or running individual test methods, will also work without any extra configuration."));
            } else {
                log.error((Object)("Internal error: Could not read configuration while evaluating whether to run " + String.valueOf(context.getRequiredTestClass()) + ". Please let the Quarkus team know what you were doing when this error happened."));
            }
            log.debug((Object)("Underlying exception: " + String.valueOf(e)));
            log.debug((Object)("Thread Context ClassLoader: " + String.valueOf(Thread.currentThread().getContextClassLoader())));
            log.debug((Object)("The classloader of the class we use for mapping is " + String.valueOf(TestConfig.class.getClassLoader())));
            String message = isVSCode || isMaybeVSCode ? "Could not execute test class because it was loaded with the wrong classloader by the VS Code test runner. Try running test methods individually instead." : (isEclipse ? "Could not execute test class because it was loaded with the wrong classloader by the Eclipse test runner. Try running test methods individually, or edit the run configuration and add `-uniqueId [engine:junit-jupiter]/[class:" + context.getRequiredTestClass().getName() + "]` in the program arguments. " : "Internal error: Test class was loaded with an unexpected classloader (" + String.valueOf(context.getRequiredTestClass().getClassLoader()) + ") or the thread context classloader (" + String.valueOf(Thread.currentThread().getContextClassLoader()) + ") was incorrect.");
            throw new IllegalStateException(message, e);
        }
        finally {
            if (!isFlatClasspath) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        Optional tags = testConfig.profile().tags();
        if (tags.isEmpty() || ((List)tags.get()).isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"No Quarkus Test Profile tags");
        }
        Class<? extends QuarkusTestProfile> testProfile = this.getQuarkusTestProfile(context);
        if (testProfile == null) {
            return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' is not annotated with '@QuarkusTestProfile' but 'quarkus.profile.test.tags' was set"));
        }
        try {
            profileInstance = testProfile.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set<String> testProfileTags = profileInstance.tags();
        for (String tag : (List)tags.get()) {
            String trimmedTag = tag.trim();
            if (!testProfileTags.contains(trimmedTag)) continue;
            return ConditionEvaluationResult.enabled((String)("Tag '" + trimmedTag + "' is present on '" + String.valueOf(testProfile) + "' which is used on test '" + String.valueOf(context.getRequiredTestClass())));
        }
        return ConditionEvaluationResult.disabled((String)("Test '" + String.valueOf(context.getRequiredTestClass()) + "' disabled because 'quarkus.profile.test.tags' don't match the tags of '" + String.valueOf(testProfile) + "'"));
    }

    static {
        currentTestClassStack = new ArrayDeque();
        log = Logger.getLogger(StartupActionImpl.class);
    }
}

