/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.deployment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmoAdaptor;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.Reflections;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.jackson.JacksonMixin;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jackson.deployment.IgnoreJsonDeserializeClassBuildItem;
import io.quarkus.jackson.runtime.ConfigurationCustomizer;
import io.quarkus.jackson.runtime.JacksonBuildTimeConfig;
import io.quarkus.jackson.runtime.JacksonSupport;
import io.quarkus.jackson.runtime.JacksonSupportRecorder;
import io.quarkus.jackson.runtime.MixinsRecorder;
import io.quarkus.jackson.runtime.ObjectMapperProducer;
import io.quarkus.jackson.runtime.VertxHybridPoolObjectMapperCustomizer;
import io.quarkus.jackson.spi.ClassPathJacksonModuleBuildItem;
import io.quarkus.jackson.spi.JacksonModuleBuildItem;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class JacksonProcessor {
    private static final DotName JSON_DESERIALIZE = DotName.createSimple((String)JsonDeserialize.class.getName());
    private static final DotName JSON_SERIALIZE = DotName.createSimple((String)JsonSerialize.class.getName());
    private static final DotName JSON_AUTO_DETECT = DotName.createSimple((String)JsonAutoDetect.class.getName());
    private static final DotName JSON_TYPE_ID_RESOLVER = DotName.createSimple((String)JsonTypeIdResolver.class.getName());
    private static final DotName JSON_SUBTYPES = DotName.createSimple((String)JsonSubTypes.class.getName());
    private static final DotName JACKSON_NAMING = DotName.createSimple((String)JsonNaming.class.getName());
    private static final DotName JSON_CREATOR = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonCreator");
    private static final DotName JSON_NAMING = DotName.createSimple((String)"com.fasterxml.jackson.databind.annotation.JsonNaming");
    private static final DotName JSON_IDENTITY_INFO = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonIdentityInfo");
    private static final DotName BUILDER_VOID = DotName.createSimple((String)Void.class.getName());
    private static final String TIME_MODULE = "com.fasterxml.jackson.datatype.jsr310.JavaTimeModule";
    private static final String JDK8_MODULE = "com.fasterxml.jackson.datatype.jdk8.Jdk8Module";
    private static final String PARAMETER_NAMES_MODULE = "com.fasterxml.jackson.module.paramnames.ParameterNamesModule";
    private static final DotName JACKSON_MIXIN = DotName.createSimple((String)JacksonMixin.class.getName());
    private static final List<String> MODULES_NAMES_TO_AUTO_REGISTER = Arrays.asList("com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", "com.fasterxml.jackson.datatype.jdk8.Jdk8Module", "com.fasterxml.jackson.module.paramnames.ParameterNamesModule");
    private static final String[] EMPTY_STRING = new String[0];
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    List<IgnoreJsonDeserializeClassBuildItem> ignoreJsonDeserializeClassBuildItems;

    @BuildStep
    void unremovable(Capabilities capabilities, BuildProducer<UnremovableBeanBuildItem> producer, BuildProducer<AdditionalBeanBuildItem> additionalProducer) {
        additionalProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(ConfigurationCustomizer.class));
        if (capabilities.isPresent("io.quarkus.vertx.core")) {
            producer.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{ObjectMapper.class}));
            additionalProducer.produce((BuildItem)AdditionalBeanBuildItem.unremovableOf(VertxHybridPoolObjectMapperCustomizer.class));
        }
    }

    @BuildStep
    void register(CurateOutcomeBuildItem curateOutcomeBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethod, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.ser.std.SqlDateSerializer", "com.fasterxml.jackson.databind.ser.std.SqlTimeSerializer", "com.fasterxml.jackson.databind.deser.std.DateDeserializers$SqlDateDeserializer", "com.fasterxml.jackson.databind.deser.std.DateDeserializers$TimestampDeserializer", "com.fasterxml.jackson.annotation.SimpleObjectIdResolver"}).methods().build());
        reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.databind.ser.std.ClassSerializer", "com.fasterxml.jackson.databind.ext.CoreXMLSerializers", "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers"}).constructors().build());
        if (curateOutcomeBuildItem.getApplicationModel().getDependencies().stream().anyMatch(x -> x.getGroupId().equals("com.fasterxml.jackson.module") && x.getArtifactId().equals("jackson-module-jaxb-annotations"))) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{"com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector"}).methods().build());
        }
        IndexView index = this.combinedIndexBuildItem.getIndex();
        HashSet<DotName> ignoredDotNames = new HashSet<DotName>();
        for (IgnoreJsonDeserializeClassBuildItem ignoreJsonDeserializeClassBuildItem : this.ignoreJsonDeserializeClassBuildItems) {
            ignoredDotNames.addAll(ignoreJsonDeserializeClassBuildItem.getDotNames());
        }
        for (AnnotationInstance deserializeInstance : index.getAnnotations(JSON_DESERIALIZE)) {
            AnnotationValue contentUsingValue;
            AnnotationValue keyUsingValue;
            AnnotationValue usingValue;
            AnnotationTarget annotationTarget = deserializeInstance.target();
            if (AnnotationTarget.Kind.CLASS.equals((Object)annotationTarget.kind())) {
                DotName builderClassName;
                AnnotationValue annotationValue;
                DotName dotName = annotationTarget.asClass().name();
                if (!ignoredDotNames.contains(dotName)) {
                    this.addReflectiveHierarchyClass(dotName, reflectiveHierarchyClass);
                }
                if (null != (annotationValue = deserializeInstance.value("builder")) && AnnotationValue.Kind.CLASS.equals((Object)annotationValue.kind()) && !BUILDER_VOID.equals((Object)(builderClassName = annotationValue.asClass().name()))) {
                    this.addReflectiveHierarchyClass(builderClassName, reflectiveHierarchyClass);
                }
            }
            if ((usingValue = deserializeInstance.value("using")) != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{usingValue.asClass().name().toString()}).build());
            }
            if ((keyUsingValue = deserializeInstance.value("keyUsing")) != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{keyUsingValue.asClass().name().toString()}).build());
            }
            if ((contentUsingValue = deserializeInstance.value("contentUsing")) == null) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{contentUsingValue.asClass().name().toString()}).build());
        }
        for (AnnotationInstance serializeInstance : index.getAnnotations(JSON_SERIALIZE)) {
            AnnotationValue nullsUsingValue;
            AnnotationInstance[] contentUsingValue;
            AnnotationValue keyUsingValue;
            AnnotationValue usingValue = serializeInstance.value("using");
            if (usingValue != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{usingValue.asClass().name().toString()}).build());
            }
            if ((keyUsingValue = serializeInstance.value("keyUsing")) != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{keyUsingValue.asClass().name().toString()}).build());
            }
            if ((contentUsingValue = serializeInstance.value("contentUsing")) != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{contentUsingValue.asClass().name().toString()}).build());
            }
            if ((nullsUsingValue = serializeInstance.value("nullsUsing")) == null) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{nullsUsingValue.asClass().name().toString()}).build());
        }
        for (AnnotationInstance creatorInstance : index.getAnnotations(JSON_AUTO_DETECT)) {
            if (creatorInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{creatorInstance.target().asClass().name().toString()}).methods().fields().build());
        }
        for (AnnotationInstance resolverInstance : index.getAnnotations(JSON_TYPE_ID_RESOLVER)) {
            AnnotationValue value = resolverInstance.value("value");
            if (value == null) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{value.asClass().name().toString()}).methods().fields().build());
            if (resolverInstance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            this.addReflectiveHierarchyClass(resolverInstance.target().asClass().name(), reflectiveHierarchyClass);
        }
        for (AnnotationInstance creatorInstance : index.getAnnotations(JSON_CREATOR)) {
            if (AnnotationTarget.Kind.METHOD != creatorInstance.target().kind()) continue;
            reflectiveMethod.produce((BuildItem)new ReflectiveMethodBuildItem(creatorInstance.target().asMethod()));
        }
        for (AnnotationInstance jsonNamingInstance : index.getAnnotations(JSON_NAMING)) {
            AnnotationValue strategyValue = jsonNamingInstance.value("value");
            if (strategyValue == null) continue;
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{strategyValue.asClass().name().toString()}).methods().fields().build());
        }
        for (Object jsonIdentityInfoInstance : index.getAnnotations(JSON_IDENTITY_INFO)) {
            AnnotationValue generatorValue = jsonIdentityInfoInstance.value("generator");
            AnnotationValue resolverValue = jsonIdentityInfoInstance.value("resolver");
            if (generatorValue != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{generatorValue.asClass().name().toString()}).methods().fields().build());
            }
            if (resolverValue != null) {
                reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{resolverValue.asClass().name().toString()}).methods().fields().build());
                continue;
            }
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((Class[])new Class[]{SimpleObjectIdResolver.class}).methods().fields().build());
        }
        HashSet<String> subTypeTypesNames = new HashSet<String>();
        for (AnnotationInstance subTypeInstance : index.getAnnotations(JSON_SUBTYPES)) {
            AnnotationValue subTypeValue = subTypeInstance.value();
            if (subTypeValue == null) continue;
            for (AnnotationInstance subTypeTypeInstance : subTypeValue.asNestedArray()) {
                AnnotationValue subTypeTypeValue = subTypeTypeInstance.value();
                if (subTypeTypeValue == null) continue;
                subTypeTypesNames.add(subTypeTypeValue.asClass().name().toString());
            }
        }
        if (!subTypeTypesNames.isEmpty()) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])subTypeTypesNames.toArray(EMPTY_STRING)).methods().fields().build());
        }
        HashSet<String> namingTypesNames = new HashSet<String>();
        for (AnnotationInstance namingInstance : index.getAnnotations(JSON_NAMING)) {
            AnnotationValue namingValue = namingInstance.value();
            if (namingValue == null) continue;
            namingTypesNames.add(namingValue.asClass().name().toString());
        }
        if (!namingTypesNames.isEmpty()) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])namingTypesNames.toArray(EMPTY_STRING)).build());
        }
        additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{ObjectMapperProducer.class}));
    }

    private void addReflectiveHierarchyClass(DotName className, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchyClass) {
        reflectiveHierarchyClass.produce((BuildItem)ReflectiveHierarchyBuildItem.builder((DotName)className).source(this.getClass().getSimpleName() + " > " + className).build());
    }

    @BuildStep
    void autoRegisterModules(BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        for (String module : MODULES_NAMES_TO_AUTO_REGISTER) {
            this.registerModuleIfOnClassPath(module, classPathJacksonModules);
        }
    }

    private void registerModuleIfOnClassPath(String moduleClassName, BuildProducer<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        if (QuarkusClassLoader.isClassPresentAtRuntime((String)moduleClassName)) {
            classPathJacksonModules.produce((BuildItem)new ClassPathJacksonModuleBuildItem(moduleClassName));
        }
    }

    @BuildStep
    void generateCustomizer(BuildProducer<GeneratedBeanBuildItem> generatedBeans, List<JacksonModuleBuildItem> jacksonModules, List<ClassPathJacksonModuleBuildItem> classPathJacksonModules) {
        if (jacksonModules.isEmpty() && classPathJacksonModules.isEmpty()) {
            return;
        }
        GeneratedBeanGizmoAdaptor classOutput = new GeneratedBeanGizmoAdaptor(generatedBeans);
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)classOutput).className("io.quarkus.jackson.customizer.RegisterSerializersAndDeserializersCustomizer").interfaces(new String[]{ObjectMapperCustomizer.class.getName()}).build();){
            classCreator.addAnnotation(Singleton.class);
            try (MethodCreator customize = classCreator.getMethodCreator("customize", Void.TYPE, new Class[]{ObjectMapper.class});){
                ResultHandle module;
                ResultHandle objectMapper = customize.getMethodParam(0);
                for (JacksonModuleBuildItem jacksonModule : jacksonModules) {
                    if (jacksonModule.getItems().isEmpty()) continue;
                    module = customize.newInstance(MethodDescriptor.ofConstructor(SimpleModule.class, (Class[])new Class[]{String.class}), new ResultHandle[]{customize.load(jacksonModule.getName())});
                    for (JacksonModuleBuildItem.Item item : jacksonModule.getItems()) {
                        String deserializerClassName;
                        ResultHandle targetClass = customize.loadClassFromTCCL(item.getTargetClassName());
                        String serializerClassName = item.getSerializerClassName();
                        if (serializerClassName != null && !serializerClassName.isEmpty()) {
                            ResultHandle serializer = customize.newInstance(MethodDescriptor.ofConstructor((String)serializerClassName, (String[])new String[0]), new ResultHandle[0]);
                            customize.invokeVirtualMethod(MethodDescriptor.ofMethod(SimpleModule.class, (String)"addSerializer", SimpleModule.class, (Class[])new Class[]{Class.class, JsonSerializer.class}), module, new ResultHandle[]{targetClass, serializer});
                        }
                        if ((deserializerClassName = item.getDeserializerClassName()) == null || deserializerClassName.isEmpty()) continue;
                        ResultHandle deserializer = customize.newInstance(MethodDescriptor.ofConstructor((String)deserializerClassName, (String[])new String[0]), new ResultHandle[0]);
                        customize.invokeVirtualMethod(MethodDescriptor.ofMethod(SimpleModule.class, (String)"addDeserializer", SimpleModule.class, (Class[])new Class[]{Class.class, JsonDeserializer.class}), module, new ResultHandle[]{targetClass, deserializer});
                    }
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(ObjectMapper.class, (String)"registerModule", ObjectMapper.class, (Class[])new Class[]{Module.class}), objectMapper, new ResultHandle[]{module});
                }
                for (ClassPathJacksonModuleBuildItem classPathJacksonModule : classPathJacksonModules) {
                    module = customize.newInstance(MethodDescriptor.ofConstructor((String)classPathJacksonModule.getModuleClassName(), (String[])new String[0]), new ResultHandle[0]);
                    customize.invokeVirtualMethod(MethodDescriptor.ofMethod(ObjectMapper.class, (String)"registerModule", ObjectMapper.class, (Class[])new Class[]{Module.class}), objectMapper, new ResultHandle[]{module});
                }
                customize.returnValue(null);
            }
            try (MethodCreator priority = classCreator.getMethodCreator("priority", Integer.TYPE, new Class[0]);){
                priority.returnValue(priority.load(-2147483548));
            }
        }
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public void supportMixins(MixinsRecorder recorder, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) {
        IndexView index = combinedIndexBuildItem.getIndex();
        Collection jacksonMixins = index.getAnnotations(JACKSON_MIXIN);
        if (jacksonMixins.isEmpty()) {
            return;
        }
        HashMap mixinsMap = new HashMap();
        for (AnnotationInstance instance : jacksonMixins) {
            if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
            ClassInfo mixinClassInfo = instance.target().asClass();
            String mixinClassName = mixinClassInfo.name().toString();
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{mixinClassName}).methods().fields().build());
            try {
                Type[] targetTypes = instance.value().asClassArray();
                if (targetTypes == null || targetTypes.length == 0) continue;
                Class<?> mixinClass = Thread.currentThread().getContextClassLoader().loadClass(mixinClassName);
                for (Type targetType : targetTypes) {
                    String targetClassName = targetType.name().toString();
                    reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{targetClassName}).methods().fields().build());
                    mixinsMap.put(Thread.currentThread().getContextClassLoader().loadClass(targetClassName), mixinClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Unable to determine Jackson mixin usage at build", e);
            }
        }
        if (mixinsMap.isEmpty()) {
            return;
        }
        syntheticBeans.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ObjectMapperCustomizer.class).scope(Singleton.class)).supplier(recorder.customizerSupplier(mixinsMap)).done());
    }

    @Record(value=ExecutionTime.STATIC_INIT)
    @BuildStep
    public SyntheticBeanBuildItem jacksonSupport(JacksonSupportRecorder recorder, JacksonBuildTimeConfig jacksonBuildTimeConfig) {
        return ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JacksonSupport.class).scope(Singleton.class)).supplier(recorder.supplier(this.determinePropertyNamingStrategyClassName(jacksonBuildTimeConfig))).done();
    }

    private Optional<String> determinePropertyNamingStrategyClassName(JacksonBuildTimeConfig jacksonBuildTimeConfig) {
        Field field;
        if (jacksonBuildTimeConfig.propertyNamingStrategy.isEmpty()) {
            return Optional.empty();
        }
        String propertyNamingStrategy = (String)jacksonBuildTimeConfig.propertyNamingStrategy.get();
        try {
            field = Reflections.findField(PropertyNamingStrategies.class, (String)propertyNamingStrategy);
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(propertyNamingStrategy);
                if (PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
                    return Optional.of(propertyNamingStrategy);
                }
                throw new RuntimeException(JacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(JacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
            }
        }
        try {
            Class<?> clazz = field.get(null).getClass();
            if (PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
                return Optional.of(clazz.getName());
            }
            throw new RuntimeException(JacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(JacksonProcessor.invalidPropertyNameStrategyValueMessage(propertyNamingStrategy));
        }
    }

    private static String invalidPropertyNameStrategyValueMessage(String propertyNamingStrategy) {
        return "Unable to determine the property naming strategy for value '" + propertyNamingStrategy + "'. Make sure that the value is either a fully qualified class name of a subclass of '" + PropertyNamingStrategy.class.getName() + "' or one of the constants defined in '" + PropertyNamingStrategies.class.getName() + "'.";
    }
}

