/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.logstream;

import io.quarkus.arc.Arc;
import io.quarkus.devui.runtime.logstream.LogStreamBroadcaster;
import io.quarkus.runtime.annotations.DevMCPEnableByDefault;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.mutiny.Multi;
import io.vertx.core.json.JsonObject;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;

public class LogStreamJsonRPCService {
    private static final org.jboss.logging.Logger LOG = org.jboss.logging.Logger.getLogger(LogStreamJsonRPCService.class);

    @NonBlocking
    public String ping() {
        return "pong";
    }

    @NonBlocking
    @JsonRpcDescription(value="Get a short Quarkus application log file history (last 60 lines)")
    public List<JsonObject> history() {
        LogStreamBroadcaster logStreamBroadcaster = (LogStreamBroadcaster)Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
        LinkedBlockingQueue<JsonObject> history = logStreamBroadcaster.getHistory();
        return new ArrayList<JsonObject>(history);
    }

    @JsonRpcDescription(value="Stream the Quarkus application log file")
    public Multi<JsonObject> streamLog() {
        LogStreamBroadcaster logStreamBroadcaster = (LogStreamBroadcaster)Arc.container().instance(LogStreamBroadcaster.class, new Annotation[0]).get();
        return logStreamBroadcaster.getLogStream();
    }

    @NonBlocking
    @JsonRpcDescription(value="Get all the available loggers in this Quarkus application")
    @DevMCPEnableByDefault
    public List<JsonObject> getLoggers() {
        LogContext logContext = LogContext.getLogContext();
        ArrayList<JsonObject> values = new ArrayList<JsonObject>();
        Enumeration loggerNames = logContext.getLoggerNames();
        while (loggerNames.hasMoreElements()) {
            String loggerName = (String)loggerNames.nextElement();
            JsonObject jsonObject = this.getLogger(loggerName);
            if (jsonObject == null) continue;
            values.add(jsonObject);
        }
        return values;
    }

    @NonBlocking
    @JsonRpcDescription(value="Get a specific logger in this Quarkus application")
    @DevMCPEnableByDefault
    public JsonObject getLogger(@JsonRpcDescription(value="The name of the logger") String loggerName) {
        LogContext logContext = LogContext.getLogContext();
        if (loggerName != null && !loggerName.isEmpty()) {
            Logger logger = logContext.getLogger(loggerName);
            return JsonObject.of((String)"name", (Object)loggerName, (String)"effectiveLevel", (Object)this.getEffectiveLogLevel(logger), (String)"configuredLevel", (Object)this.getConfiguredLogLevel(logger));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonBlocking
    @JsonRpcDescription(value="Update a specific logger's log level in this Quarkus application")
    @DevMCPEnableByDefault
    public JsonObject updateLogLevel(@JsonRpcDescription(value="The name of the logger") String loggerName, @JsonRpcDescription(value="The new level of the logger") String levelValue) {
        Level level;
        LogContext logContext = LogContext.getLogContext();
        Logger logger = logContext.getLogger(loggerName);
        if (levelValue == null || levelValue.isBlank()) {
            if (logger.getParent() == null) throw new IllegalArgumentException("The level of the root logger cannot be set to null");
            level = logger.getParent().getLevel();
        } else {
            level = Level.parse(levelValue);
        }
        logger.setLevel(level);
        LOG.info((Object)("Log level updated [" + loggerName + "] changed to [" + levelValue + "]"));
        return this.getLogger(loggerName);
    }

    private String getConfiguredLogLevel(Logger logger) {
        Level level = logger.getLevel();
        return level != null ? level.getName() : null;
    }

    private String getEffectiveLogLevel(Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.getLevel() != null) {
            return logger.getLevel().getName();
        }
        return this.getEffectiveLogLevel(logger.getParent());
    }
}

