/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.registry.catalog.Platform;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JsonPlatform
implements Platform {
    private ArtifactCoords bom;
    private String quarkusCore;
    private String upstreamQuarkusCore;

    public static JsonPlatform of(ArtifactCoords bom) {
        JsonPlatform p = new JsonPlatform();
        p.setBom(Objects.requireNonNull(bom, "bom can't be null"));
        return p;
    }

    @Override
    public ArtifactCoords getBom() {
        return this.bom;
    }

    public void setBom(ArtifactCoords bom) {
        this.bom = bom;
    }

    @Override
    public String getQuarkusCoreVersion() {
        return this.quarkusCore;
    }

    public void setQuarkusCoreVersion(String quarkusCore) {
        this.quarkusCore = quarkusCore;
    }

    @Override
    public String getUpstreamQuarkusCoreVersion() {
        return this.upstreamQuarkusCore;
    }

    public void setUpstreamQuarkusCoreVersion(String upstreamQuarkusCore) {
        this.upstreamQuarkusCore = upstreamQuarkusCore;
    }

    public String toString() {
        return "[platform " + this.bom + ", quarkus-core=" + this.quarkusCore + ", upstream-quarkus-core=" + this.upstreamQuarkusCore + "]";
    }
}

