/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.exec;

import io.smallrye.common.process.ProcessBuilder;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;

public class ExecSupport {
    private final PrintWriter out;
    private final PrintWriter err;
    private final boolean verbose;
    private final boolean cliTest;

    public ExecSupport() {
        this(System.out, System.err, false, false);
    }

    public ExecSupport(PrintStream out, PrintStream err, boolean verbose, boolean cliTest) {
        this(new PrintWriter(out), new PrintWriter(err), verbose, cliTest);
    }

    public ExecSupport(PrintWriter out, PrintWriter err, boolean verbose, boolean cliTest) {
        this.out = out;
        this.err = err;
        this.verbose = verbose;
        this.cliTest = cliTest;
    }

    public int executeProcess(String[] args, File parentDir) {
        if (this.isVerbose()) {
            this.out.println(String.join((CharSequence)" ", args));
            this.out.println();
        }
        var holder = new Object(){
            int exitCode;
        };
        ProcessBuilder.Input pb = ProcessBuilder.newBuilder((String)args[0]).arguments(List.of(args).subList(1, args.length)).directory(parentDir.toPath()).exitCodeChecker(ec -> {
            holder.exitCode = ec;
            return true;
        }).input().empty();
        if (this.isCliTest()) {
            pb.output().transferTo((Writer)this.out).error().transferTo((Writer)this.err).run();
        } else {
            pb.output().inherited().error().inherited().run();
        }
        return holder.exitCode;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isCliTest() {
        return this.cliTest;
    }
}

