/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.quarkus.devtools.codestarts.CodestartResource;
import io.quarkus.devtools.codestarts.CodestartStructureException;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.DefaultCodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

final class FailOnDuplicateCodestartFileStrategyHandler
implements DefaultCodestartFileStrategyHandler {
    static final String NAME = "fail-on-duplicate";

    FailOnDuplicateCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        if (codestartFiles.size() > 1 || Files.exists(targetPath, new LinkOption[0])) {
            throw new CodestartStructureException("Multiple files found for path with 'fail-on-duplicate' FileStrategy: " + relativePath);
        }
        this.createDirectories(targetPath);
        this.writeFile(targetPath, codestartFiles.get(0).getContent());
    }

    @Override
    public void copyStaticFile(CodestartResource.Source source, Path targetPath) throws IOException {
        if (Files.exists(targetPath, new LinkOption[0])) {
            throw new CodestartStructureException("Multiple files found for path with 'fail-on-duplicate' FileStrategy: " + source.absolutePath() + ":" + String.valueOf(targetPath));
        }
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        source.copyTo(targetPath, new CopyOption[0]);
    }
}

