/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public final class DefaultConfigSource
extends PropertiesConfigSource {
    private static final long serialVersionUID = -6482737535291300045L;
    public static final String DEFAULT_CONFIG_PROPERTIES_NAME = "META-INF/quarkus-default-config.properties";

    public DefaultConfigSource() {
        super(DefaultConfigSource.getMap(), "Default configuration values", 0);
    }

    private static Map<String, String> getMap() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = DefaultConfigSource.class.getClassLoader();
        }
        try {
            Enumeration<URL> resources;
            Properties p = new Properties();
            Enumeration<URL> enumeration = resources = cl == null ? ClassLoader.getSystemResources(DEFAULT_CONFIG_PROPERTIES_NAME) : cl.getResources(DEFAULT_CONFIG_PROPERTIES_NAME);
            if (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try (InputStream is = url.openStream();
                     InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);){
                    p.load(isr);
                }
            }
            return p;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read default configuration", e);
        }
    }
}

