/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.devservices;

public record ImageName(String fullName, String registry, String repository, Version version) {
    private static final String LIBRARY_PREFIX = "library/";

    public static ImageName parse(String fullName) {
        Version version;
        String repository;
        String remoteName;
        String registry;
        int slashIndex = fullName.indexOf(47);
        if (slashIndex == -1 || !fullName.substring(0, slashIndex).contains(".") && !fullName.substring(0, slashIndex).contains(":") && !fullName.substring(0, slashIndex).equals("localhost")) {
            registry = "";
            remoteName = fullName;
        } else {
            registry = fullName.substring(0, slashIndex);
            remoteName = fullName.substring(slashIndex + 1);
        }
        if (remoteName.contains("@sha256:")) {
            repository = remoteName.split("@sha256:")[0];
            version = new Version.Sha256(remoteName.split("@sha256:")[1]);
        } else if (remoteName.contains(":")) {
            repository = remoteName.split(":")[0];
            version = new Version.Tag(remoteName.split(":")[1]);
        } else {
            repository = remoteName;
            version = new Version.Any();
        }
        return new ImageName(fullName, registry, repository, version);
    }

    public String getUnversionedPart() {
        if (!"".equals(this.registry)) {
            return this.registry + "/" + this.repository;
        }
        return this.repository;
    }

    public String getVersionPart() {
        return this.version.toString();
    }

    public ImageName withLibraryPrefix() {
        if (this.repository.startsWith(LIBRARY_PREFIX)) {
            return this;
        }
        return new ImageName(this.fullName, this.registry, LIBRARY_PREFIX + this.repository, this.version);
    }

    @Override
    public String toString() {
        return this.getUnversionedPart() + this.version.getSeparator() + this.getVersionPart();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static class Version {
        public final String version;

        public Version(String version) {
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public String getSeparator() {
            return ":";
        }

        public String toString() {
            return this.version + this.getSeparator();
        }

        private static final class Any
        extends Version {
            public Any() {
                super("latest");
            }
        }

        private static final class Sha256
        extends Version {
            private Sha256(String version) {
                super(version);
            }

            @Override
            public String getSeparator() {
                return "@";
            }

            @Override
            public String toString() {
                return "sha256:" + this.version;
            }
        }

        private static final class Tag
        extends Version {
            public Tag(String version) {
                super(version);
            }
        }
    }
}

