/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.bootstrap.json.Json;
import io.quarkus.builder.StepInfo;
import io.quarkus.builder.item.BuildItem;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class BuildMetrics {
    public static final String BUILDER_METRICS_ENABLED = "quarkus.builder.metrics.enabled";
    public static final String BUILDER_METRICS_EXTENDED_CAPTURE = "quarkus.builder.metrics.extended-capture";
    static final Logger LOG = Logger.getLogger((String)BuildMetrics.class.getName());
    private volatile LocalDateTime started;
    private volatile long duration;
    private final String buildTargetName;
    private final ConcurrentMap<String, BuildStepRecord> records;
    private final ConcurrentMap<String, Long> buildItems;
    private final ConcurrentMap<String, List<String>> buildItemsExtended;
    private final AtomicInteger idGenerator;

    public BuildMetrics(String buildTargetName) {
        boolean enabled = Boolean.getBoolean(BUILDER_METRICS_ENABLED) || Boolean.getBoolean("quarkus.debug.dump-build-metrics");
        this.buildTargetName = buildTargetName;
        if (enabled) {
            this.idGenerator = new AtomicInteger();
            this.records = new ConcurrentHashMap<String, BuildStepRecord>();
            if (Boolean.getBoolean(BUILDER_METRICS_EXTENDED_CAPTURE)) {
                this.buildItemsExtended = new ConcurrentHashMap<String, List<String>>();
                this.buildItems = null;
            } else {
                this.buildItemsExtended = null;
                this.buildItems = new ConcurrentHashMap<String, Long>();
            }
        } else {
            this.idGenerator = null;
            this.records = null;
            this.buildItemsExtended = null;
            this.buildItems = null;
        }
    }

    public Collection<BuildStepRecord> getRecords() {
        return this.records.values();
    }

    public void buildStarted() {
        this.started = LocalDateTime.now().truncatedTo(ChronoUnit.MILLIS);
    }

    public void buildFinished(long duration) {
        this.duration = duration;
    }

    public void buildStepFinished(StepInfo stepInfo, String thread, LocalTime started, long duration) {
        if (this.enabled()) {
            this.records.put(stepInfo.getBuildStep().getId(), new BuildStepRecord(this.idGenerator.incrementAndGet(), stepInfo, thread, started, duration));
        }
    }

    public void buildItemProduced(StepInfo stepInfo, BuildItem buildItem) {
        if (this.enabled()) {
            if (this.buildItems != null) {
                this.buildItems.compute(buildItem.getClass().getName(), this::itemProduced);
            } else {
                this.buildItemsExtended.compute(stepInfo.getBuildStep().getId(), (key, list) -> {
                    String buildItemClass = buildItem.getClass().getName();
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(buildItemClass);
                    return list;
                });
            }
        }
    }

    private Long itemProduced(String key, Long val) {
        return val == null ? 1L : val + 1L;
    }

    public void dumpTo(Path file) throws IOException {
        if (this.enabled()) {
            ArrayList<Object> sortedItems;
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
            ArrayList sortedSteps = new ArrayList(this.records.values());
            sortedSteps.sort(new Comparator<BuildStepRecord>(){

                @Override
                public int compare(BuildStepRecord o1, BuildStepRecord o2) {
                    return Long.compare(o2.duration, o1.duration);
                }
            });
            Json.JsonObjectBuilder json = Json.object();
            json.put("buildTarget", this.buildTargetName);
            json.put("started", this.started.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));
            json.put("duration", this.duration);
            Json.JsonArrayBuilder steps = Json.array();
            json.put("records", steps);
            for (BuildStepRecord rec : sortedSteps) {
                Object items;
                Json.JsonObjectBuilder recObject = Json.object();
                recObject.put("id", rec.id);
                recObject.put("stepId", rec.stepInfo.getBuildStep().getId());
                recObject.put("thread", rec.thread);
                recObject.put("started", rec.started.format(formatter));
                recObject.put("duration", rec.duration);
                Json.JsonArrayBuilder dependentsArray = Json.array();
                for (StepInfo stepInfo : rec.stepInfo.getDependents()) {
                    BuildStepRecord dependentRecord = (BuildStepRecord)this.records.get(stepInfo.getBuildStep().getId());
                    if (dependentRecord != null) {
                        dependentsArray.add(dependentRecord.id);
                        continue;
                    }
                    LOG.warnf("Dependent record not found for stepId: %s", (Object)stepInfo.getBuildStep().getId());
                }
                recObject.put("dependents", dependentsArray);
                if (this.buildItemsExtended != null && (items = (List)this.buildItemsExtended.get(rec.stepInfo.getBuildStep().getId())) != null) {
                    Json.JsonArrayBuilder jsonArrayBuilder = Json.array();
                    Map counts = items.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                    ArrayList sortedItems2 = new ArrayList(counts.entrySet());
                    sortedItems2.sort(this::compareBuildItems);
                    for (Map.Entry entry : sortedItems2) {
                        jsonArrayBuilder.add(Json.object().put("item", (String)entry.getKey()).put("count", ((Long)entry.getValue()).longValue()));
                    }
                    recObject.put("producedItems", jsonArrayBuilder);
                }
                steps.add(recObject);
            }
            if (this.buildItemsExtended != null) {
                Map counts = this.buildItemsExtended.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
                sortedItems = new ArrayList(counts.entrySet());
            } else {
                sortedItems = new ArrayList(this.buildItems.size());
                this.buildItems.entrySet().forEach(sortedItems::add);
            }
            sortedItems.sort(this::compareBuildItems);
            Json.JsonArrayBuilder items = Json.array();
            json.put("items", items);
            long itemsCount = 0L;
            for (Map.Entry entry : sortedItems) {
                Json.JsonObjectBuilder itemObject = Json.object();
                itemObject.put("class", (String)entry.getKey());
                itemObject.put("count", entry.getValue());
                items.add(itemObject);
                itemsCount += ((Long)entry.getValue()).longValue();
            }
            json.put("itemsCount", itemsCount);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file.toFile(), StandardCharsets.UTF_8));){
                json.appendTo((Appendable)writer);
            }
        }
    }

    private boolean enabled() {
        return this.records != null;
    }

    private int compareBuildItems(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
        return Long.compare(o2.getValue(), o1.getValue());
    }

    public static class BuildStepRecord {
        public final int id;
        public final StepInfo stepInfo;
        public final String thread;
        public final LocalTime started;
        public final long duration;

        BuildStepRecord(int id, StepInfo stepInfo, String thread, LocalTime started, long duration) {
            this.id = id;
            this.stepInfo = stepInfo;
            this.thread = thread;
            this.started = started;
            this.duration = duration;
        }
    }
}

