/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.json;

import io.quarkus.bootstrap.json.JsonArray;
import io.quarkus.bootstrap.json.JsonBoolean;
import io.quarkus.bootstrap.json.JsonInteger;
import io.quarkus.bootstrap.json.JsonMember;
import io.quarkus.bootstrap.json.JsonMultiValue;
import io.quarkus.bootstrap.json.JsonObject;
import io.quarkus.bootstrap.json.JsonString;
import io.quarkus.bootstrap.json.JsonTransform;
import io.quarkus.bootstrap.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Json {
    private static final String OBJECT_START = "{";
    private static final String OBJECT_END = "}";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String NAME_VAL_SEPARATOR = ":";
    private static final String ENTRY_SEPARATOR = ",";
    private static final int CONTROL_CHAR_START = 0;
    private static final int CONTROL_CHAR_END = 31;
    private static final char CHAR_QUOTATION_MARK = '\"';
    private static final Map<Character, String> REPLACEMENTS = new HashMap<Character, String>();

    private Json() {
    }

    public static JsonArrayBuilder array() {
        return new JsonArrayBuilder(false);
    }

    public static JsonArrayBuilder array(int initialCapacity) {
        return new JsonArrayBuilder(false, initialCapacity);
    }

    public static JsonArrayBuilder array(boolean ignoreEmptyBuilders) {
        return new JsonArrayBuilder(ignoreEmptyBuilders);
    }

    public static JsonArrayBuilder array(boolean ignoreEmptyBuilders, int initialCapacity) {
        return new JsonArrayBuilder(ignoreEmptyBuilders, initialCapacity);
    }

    public static JsonObjectBuilder object() {
        return new JsonObjectBuilder(false);
    }

    public static JsonObjectBuilder object(int initialCapacity) {
        return new JsonObjectBuilder(false, initialCapacity);
    }

    public static JsonObjectBuilder object(boolean ignoreEmptyBuilders) {
        return new JsonObjectBuilder(ignoreEmptyBuilders);
    }

    public static JsonObjectBuilder object(boolean ignoreEmptyBuilders, int initialCapacity) {
        return new JsonObjectBuilder(ignoreEmptyBuilders, initialCapacity);
    }

    static void appendValue(Appendable appendable, Object value) throws IOException {
        if (value instanceof JsonObjectBuilder) {
            JsonObjectBuilder jsonObj = (JsonObjectBuilder)value;
            jsonObj.appendTo(appendable);
        } else if (value instanceof JsonArrayBuilder) {
            JsonArrayBuilder jsonArr = (JsonArrayBuilder)value;
            jsonArr.appendTo(appendable);
        } else if (value instanceof String) {
            String str = (String)value;
            Json.appendStringValue(appendable, str);
        } else if (value instanceof Boolean || value instanceof Integer || value instanceof Long) {
            appendable.append(value.toString());
        } else {
            throw new IllegalStateException("Unsupported value type: " + String.valueOf(value));
        }
    }

    static void appendStringValue(Appendable appendable, String value) throws IOException {
        appendable.append('\"');
        Json.appendEscaped(appendable, value);
        appendable.append('\"');
    }

    static void appendEscaped(Appendable appendable, String value) throws IOException {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String replacement = REPLACEMENTS.get(Character.valueOf(c));
            if (replacement != null) {
                appendable.append(replacement);
                continue;
            }
            appendable.append(c);
        }
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            REPLACEMENTS.put(Character.valueOf((char)i), String.format("\\u%04x", i));
        }
        REPLACEMENTS.put(Character.valueOf('\"'), "\\\"");
        REPLACEMENTS.put(Character.valueOf('\\'), "\\\\");
    }

    public static class JsonArrayBuilder
    extends JsonBuilder<JsonArrayBuilder>
    implements Collection<Object> {
        private final List<Object> values;

        private JsonArrayBuilder(boolean ignoreEmptyBuilders) {
            super(ignoreEmptyBuilders);
            this.values = new ArrayList<Object>();
        }

        private JsonArrayBuilder(boolean ignoreEmptyBuilders, int initialCapacity) {
            super(ignoreEmptyBuilders);
            this.values = new ArrayList<Object>(initialCapacity);
        }

        public JsonArrayBuilder add(JsonArrayBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(JsonObjectBuilder value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(String value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(boolean value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(int value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder add(long value) {
            this.addInternal(value);
            return this;
        }

        public JsonArrayBuilder addAll(List<JsonObjectBuilder> value) {
            if (value != null && !value.isEmpty()) {
                this.values.addAll(value);
            }
            return this;
        }

        void addInternal(Object value) {
            if (value != null) {
                this.values.add(value);
            }
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        public boolean isEmpty() {
            return this.isValuesEmpty(this.values);
        }

        @Override
        public boolean contains(Object o) {
            return this.values.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return this.values.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.values.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.values.toArray(a);
        }

        @Override
        public boolean add(Object o) {
            this.addInternal(o);
            return o != null;
        }

        @Override
        public boolean remove(Object o) {
            return this.values.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.values.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<?> c) {
            for (Object o : c) {
                this.addInternal(o);
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.values.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.values.retainAll(c);
        }

        @Override
        public void clear() {
            this.values.clear();
        }

        @Override
        public void appendTo(Appendable appendable) throws IOException {
            appendable.append(Json.ARRAY_START);
            int idx = 0;
            for (Object value : this.values) {
                if (this.isIgnored(value)) continue;
                if (++idx > 1) {
                    appendable.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendValue(appendable, value);
            }
            appendable.append(Json.ARRAY_END);
        }

        @Override
        protected JsonArrayBuilder self() {
            return this;
        }

        @Override
        void add(JsonValue element) {
            if (element instanceof JsonString) {
                JsonString jsonStr = (JsonString)element;
                this.add(jsonStr.value());
            } else if (element instanceof JsonInteger) {
                int intValue;
                JsonInteger jsonInt = (JsonInteger)element;
                long longValue = jsonInt.longValue();
                if (longValue == (long)(intValue = (int)longValue)) {
                    this.add(intValue);
                } else {
                    this.add(longValue);
                }
            } else if (element instanceof JsonBoolean) {
                JsonBoolean jsonBoolean = (JsonBoolean)element;
                this.add(jsonBoolean.value());
            } else if (element instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)element;
                JsonArrayBuilder arrayBuilder = Json.array(this.ignoreEmptyBuilders);
                arrayBuilder.transform(jsonArray, this.transform);
                if (!arrayBuilder.isEmpty()) {
                    this.add(arrayBuilder);
                }
            } else if (element instanceof JsonObject) {
                JsonObject jsonObj = (JsonObject)element;
                JsonObjectBuilder objectBuilder = Json.object(this.ignoreEmptyBuilders);
                objectBuilder.transform(jsonObj, this.transform);
                if (!objectBuilder.isEmpty()) {
                    this.add(objectBuilder);
                }
            }
        }
    }

    public static class JsonObjectBuilder
    extends JsonBuilder<JsonObjectBuilder>
    implements Map<String, Object> {
        private final Map<String, Object> properties;

        private JsonObjectBuilder(boolean ignoreEmptyBuilders) {
            super(ignoreEmptyBuilders);
            this.properties = new HashMap<String, Object>();
        }

        private JsonObjectBuilder(boolean ignoreEmptyBuilders, int initialCapacity) {
            super(ignoreEmptyBuilders);
            this.properties = new HashMap<String, Object>(initialCapacity);
        }

        @Override
        public JsonObjectBuilder put(String name, String value) {
            this.putInternal(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder put(String name, JsonObjectBuilder value) {
            this.putInternal(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder put(String name, JsonArrayBuilder value) {
            this.putInternal(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder put(String name, boolean value) {
            this.putInternal(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder put(String name, int value) {
            this.putInternal(name, value);
            return this;
        }

        @Override
        public JsonObjectBuilder put(String name, long value) {
            this.putInternal(name, value);
            return this;
        }

        public boolean has(String name) {
            return this.properties.containsKey(name);
        }

        Object putInternal(String name, Object value) {
            Objects.requireNonNull(name);
            if (value != null) {
                return this.properties.put(name, value);
            }
            return null;
        }

        @Override
        public int size() {
            return this.properties.size();
        }

        @Override
        public boolean isEmpty() {
            if (this.properties.isEmpty()) {
                return true;
            }
            return this.isValuesEmpty(this.properties.values());
        }

        @Override
        public boolean containsKey(Object key) {
            return this.properties.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.properties.containsValue(value);
        }

        @Override
        public Object get(Object key) {
            return this.properties.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return this.putInternal(key, value);
        }

        @Override
        public Object remove(Object key) {
            return this.properties.remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ?> m) {
            for (Map.Entry<String, ?> entry : m.entrySet()) {
                this.putInternal(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void clear() {
            this.properties.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.properties.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.properties.values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.properties.entrySet();
        }

        @Override
        public void appendTo(Appendable appendable) throws IOException {
            appendable.append(Json.OBJECT_START);
            int idx = 0;
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                if (this.isIgnored(entry.getValue())) continue;
                if (++idx > 1) {
                    appendable.append(Json.ENTRY_SEPARATOR);
                }
                Json.appendStringValue(appendable, entry.getKey());
                appendable.append(Json.NAME_VAL_SEPARATOR);
                Json.appendValue(appendable, entry.getValue());
            }
            appendable.append(Json.OBJECT_END);
        }

        @Override
        protected JsonObjectBuilder self() {
            return this;
        }

        @Override
        void add(JsonValue element) {
            if (element instanceof JsonMember) {
                JsonMember member = (JsonMember)element;
                String attribute = member.attribute().value();
                JsonValue value = member.value();
                if (value instanceof JsonString) {
                    JsonString jsonStr = (JsonString)value;
                    this.put(attribute, jsonStr.value());
                } else if (value instanceof JsonInteger) {
                    int intValue;
                    JsonInteger jsonInt = (JsonInteger)value;
                    long longValue = jsonInt.longValue();
                    if (longValue == (long)(intValue = (int)longValue)) {
                        this.put(attribute, intValue);
                    } else {
                        this.put(attribute, longValue);
                    }
                } else if (value instanceof JsonBoolean) {
                    JsonBoolean jsonBool = (JsonBoolean)value;
                    this.put(attribute, jsonBool.value());
                } else if (value instanceof JsonArray) {
                    JsonArray jsonArr = (JsonArray)value;
                    JsonArrayBuilder arrayBuilder = Json.array(this.ignoreEmptyBuilders);
                    arrayBuilder.transform(jsonArr, this.transform);
                    if (!arrayBuilder.isEmpty()) {
                        this.put(attribute, arrayBuilder);
                    }
                } else if (value instanceof JsonObject) {
                    JsonObject jsonObj = (JsonObject)value;
                    JsonObjectBuilder objectBuilder = Json.object(this.ignoreEmptyBuilders);
                    objectBuilder.transform(jsonObj, this.transform);
                    if (!objectBuilder.isEmpty()) {
                        this.put(attribute, objectBuilder);
                    }
                }
            }
        }
    }

    private static final class ResolvedTransform
    implements JsonTransform {
        private final JsonBuilder<?> resolvedBuilder;
        private final JsonTransform transform;

        private ResolvedTransform(JsonBuilder<?> resolvedBuilder, JsonTransform transform) {
            this.resolvedBuilder = resolvedBuilder;
            this.resolvedBuilder.setTransform(transform);
            this.transform = transform;
        }

        @Override
        public void accept(JsonBuilder<?> builder, JsonValue element) {
            if (builder == null) {
                this.transform.accept(this.resolvedBuilder, element);
            }
        }
    }

    public static abstract class JsonBuilder<T> {
        protected final boolean ignoreEmptyBuilders;
        protected JsonTransform transform;

        JsonBuilder(boolean ignoreEmptyBuilders) {
            this.ignoreEmptyBuilders = ignoreEmptyBuilders;
        }

        abstract boolean isEmpty();

        public abstract void appendTo(Appendable var1) throws IOException;

        protected boolean isIgnored(Object value) {
            JsonBuilder jsonBuilder;
            return value == null || this.ignoreEmptyBuilders && value instanceof JsonBuilder && (jsonBuilder = (JsonBuilder)value).isEmpty();
        }

        protected boolean isValuesEmpty(Collection<Object> values) {
            if (values.isEmpty()) {
                return true;
            }
            for (Object object : values) {
                JsonBuilder jsonBuilder;
                if (object instanceof JsonBuilder && (jsonBuilder = (JsonBuilder)object).isEmpty()) continue;
                return false;
            }
            return true;
        }

        protected abstract T self();

        abstract void add(JsonValue var1);

        void setTransform(JsonTransform transform) {
            this.transform = transform;
        }

        public void transform(JsonMultiValue value, JsonTransform transform) {
            ResolvedTransform resolved = new ResolvedTransform(this, transform);
            value.forEach(resolved);
        }
    }
}

