/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.LocalVarImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.classfile.ClassFileElement;
import io.smallrye.classfile.CodeBuilder;
import io.smallrye.classfile.Label;
import io.smallrye.classfile.Signature;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.instruction.LocalVariable;
import io.smallrye.classfile.instruction.LocalVariableType;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

final class LocalVarAllocator
extends Item {
    private final LocalVarImpl localVar;
    private Label startScope;
    private Label endScope;

    LocalVarAllocator(LocalVarImpl localVar) {
        this.localVar = localVar;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        GenericType gt;
        int slot = cb.allocateLocal(Util.actualKindOf(this.localVar.typeKind()));
        this.startScope = cb.newBoundLabel();
        this.endScope = block.endLabel();
        cb.with((ClassFileElement)LocalVariable.of((int)slot, (String)this.localVar.name(), (ClassDesc)this.localVar.type(), (Label)this.startScope, (Label)this.endScope));
        if (this.localVar.hasGenericType() && !(gt = this.localVar.genericType()).isRaw()) {
            cb.with((ClassFileElement)LocalVariableType.of((int)slot, (String)this.localVar.name(), (Signature)Util.signatureOf(gt), (Label)this.startScope, (Label)this.endScope));
        }
        this.localVar.slot = slot;
        smb.store(slot, this.localVar.type());
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        if (this.localVar.hasGenericType() && this.localVar.genericType().hasAnnotations(retention)) {
            Util.computeAnnotations(this.localVar.genericType(), retention, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofLocalVariable(List.of(TypeAnnotation.LocalVarTargetInfo.of((Label)this.startScope, (Label)this.endScope, (int)this.localVar.slot))), annotations, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
    }
}

