/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.AbstractGenerator;
import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.Beans;
import io.quarkus.arc.processor.BuiltinQualifier;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.BytecodeTransformer;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Hashes;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InjectionTargetInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.Methods;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.Types;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class BeanInfo
implements InjectionTargetInfo {
    private final String identifier;
    private final ClassInfo implClazz;
    private final Type providerType;
    protected final Optional<AnnotationTarget> target;
    private final BeanDeployment beanDeployment;
    protected final ScopeInfo scope;
    protected final Set<Type> types;
    protected final Set<AnnotationInstance> qualifiers;
    private final List<Injection> injections;
    private final BeanInfo declaringBean;
    private final DisposerInfo disposer;
    private final Map<MethodInfo, InterceptionInfo> interceptedMethods;
    private final Map<MethodInfo, DecorationInfo> decoratedMethods;
    private final Map<InterceptionType, InterceptionInfo> lifecycleInterceptors;
    private final boolean alternative;
    private final Integer priority;
    private final List<StereotypeInfo> stereotypes;
    private final String name;
    private final boolean defaultBean;
    private final boolean removable;
    private final Consumer<MethodCreator> creatorConsumer;
    private final Consumer<MethodCreator> destroyerConsumer;
    private final Map<String, Object> params;
    private final boolean forceApplicationClass;
    private final String targetPackageName;

    BeanInfo(AnnotationTarget target, BeanDeployment beanDeployment, ScopeInfo scope, Set<Type> types, Set<AnnotationInstance> qualifiers, List<Injection> injections, BeanInfo declaringBean, DisposerInfo disposer, boolean alternative, List<StereotypeInfo> stereotypes, String name, boolean isDefaultBean, String targetPackageName, Integer priority) {
        this(null, null, target, beanDeployment, scope, types, qualifiers, injections, declaringBean, disposer, alternative, stereotypes, name, isDefaultBean, null, null, Collections.emptyMap(), true, false, targetPackageName, priority);
    }

    BeanInfo(ClassInfo implClazz, Type providerType, AnnotationTarget target, BeanDeployment beanDeployment, ScopeInfo scope, Set<Type> types, Set<AnnotationInstance> qualifiers, List<Injection> injections, BeanInfo declaringBean, DisposerInfo disposer, boolean alternative, List<StereotypeInfo> stereotypes, String name, boolean isDefaultBean, Consumer<MethodCreator> creatorConsumer, Consumer<MethodCreator> destroyerConsumer, Map<String, Object> params, boolean isRemovable, boolean forceApplicationClass, String targetPackageName, Integer priority) {
        this.target = Optional.ofNullable(target);
        if (implClazz == null && target != null) {
            implClazz = this.initImplClazz(target, beanDeployment);
        }
        this.implClazz = implClazz;
        if (providerType == null) {
            providerType = this.initProviderType(target, implClazz);
        }
        this.providerType = providerType;
        this.beanDeployment = beanDeployment;
        this.scope = scope != null ? scope : BuiltinScope.DEPENDENT.getInfo();
        this.types = types;
        for (Type type : types) {
            Beans.analyzeType(type, beanDeployment);
        }
        if (qualifiers.isEmpty() || qualifiers.size() <= 2 && qualifiers.stream().allMatch(a -> DotNames.NAMED.equals((Object)a.name()) || DotNames.ANY.equals((Object)a.name()))) {
            qualifiers.add(BuiltinQualifier.DEFAULT.getInstance());
        }
        qualifiers.add(BuiltinQualifier.ANY.getInstance());
        this.qualifiers = qualifiers;
        this.injections = injections;
        this.declaringBean = declaringBean;
        this.disposer = disposer;
        this.alternative = alternative;
        this.priority = priority;
        this.stereotypes = stereotypes;
        this.name = name;
        this.defaultBean = isDefaultBean;
        this.creatorConsumer = creatorConsumer;
        this.destroyerConsumer = destroyerConsumer;
        this.removable = isRemovable;
        this.params = params;
        this.identifier = Hashes.sha1(this.toString());
        this.interceptedMethods = new ConcurrentHashMap<MethodInfo, InterceptionInfo>();
        this.decoratedMethods = new ConcurrentHashMap<MethodInfo, DecorationInfo>();
        this.lifecycleInterceptors = new ConcurrentHashMap<InterceptionType, InterceptionInfo>();
        this.forceApplicationClass = forceApplicationClass;
        this.targetPackageName = targetPackageName;
    }

    @Override
    public InjectionTargetInfo.TargetKind kind() {
        return InjectionTargetInfo.TargetKind.BEAN;
    }

    @Override
    public BeanInfo asBean() {
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Optional<AnnotationTarget> getTarget() {
        return this.target;
    }

    public ClassInfo getImplClazz() {
        return this.implClazz;
    }

    public boolean isClassBean() {
        return this.target.isPresent() && AnnotationTarget.Kind.CLASS.equals((Object)this.target.get().kind());
    }

    public boolean isProducerMethod() {
        return this.target.isPresent() && AnnotationTarget.Kind.METHOD.equals((Object)this.target.get().kind());
    }

    public boolean isProducerField() {
        return this.target.isPresent() && AnnotationTarget.Kind.FIELD.equals((Object)this.target.get().kind());
    }

    public boolean isSynthetic() {
        return !this.target.isPresent();
    }

    public boolean isRemovable() {
        return this.removable;
    }

    public DotName getBeanClass() {
        if (this.declaringBean != null) {
            return this.declaringBean.implClazz.name();
        }
        return this.implClazz.name();
    }

    public boolean isInterceptor() {
        return false;
    }

    public boolean isDecorator() {
        return false;
    }

    public BeanInfo getDeclaringBean() {
        return this.declaringBean;
    }

    BeanDeployment getDeployment() {
        return this.beanDeployment;
    }

    public Type getProviderType() {
        return this.providerType;
    }

    public ScopeInfo getScope() {
        return this.scope;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean hasType(DotName typeName) {
        for (Type type : this.types) {
            if (!type.name().equals((Object)typeName)) continue;
            return true;
        }
        return false;
    }

    public Set<AnnotationInstance> getQualifiers() {
        return this.qualifiers;
    }

    public Optional<AnnotationInstance> getQualifier(DotName dotName) {
        for (AnnotationInstance qualifier : this.qualifiers) {
            if (!qualifier.name().equals((Object)dotName)) continue;
            return Optional.of(qualifier);
        }
        return Optional.empty();
    }

    public boolean hasDefaultQualifiers() {
        return this.qualifiers.size() == 2 && this.qualifiers.contains(BuiltinQualifier.DEFAULT.getInstance()) && this.qualifiers.contains(BuiltinQualifier.ANY.getInstance());
    }

    List<Injection> getInjections() {
        return this.injections;
    }

    public List<InjectionPointInfo> getAllInjectionPoints() {
        if (this.injections.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InjectionPointInfo> injectionPoints = new ArrayList<InjectionPointInfo>();
        for (Injection injection : this.injections) {
            injectionPoints.addAll(injection.injectionPoints);
        }
        return injectionPoints;
    }

    Optional<Injection> getConstructorInjection() {
        return this.injections.isEmpty() ? Optional.empty() : this.injections.stream().filter(Injection::isConstructor).findAny();
    }

    Map<MethodInfo, InterceptionInfo> getInterceptedMethods() {
        return this.interceptedMethods;
    }

    Map<MethodInfo, DecorationInfo> getDecoratedMethods() {
        return this.decoratedMethods;
    }

    List<MethodInfo> getInterceptedOrDecoratedMethods() {
        HashSet<MethodInfo> methods = new HashSet<MethodInfo>(this.interceptedMethods.keySet());
        methods.addAll(this.decoratedMethods.keySet());
        ArrayList<MethodInfo> sorted = new ArrayList<MethodInfo>(methods);
        Collections.sort(sorted, Comparator.comparing(MethodInfo::toString));
        return sorted;
    }

    Set<MethodInfo> getDecoratedMethods(DecoratorInfo decorator) {
        HashSet<MethodInfo> decorated = new HashSet<MethodInfo>();
        for (Map.Entry<MethodInfo, DecorationInfo> entry : this.decoratedMethods.entrySet()) {
            if (!entry.getValue().decorators.contains(decorator)) continue;
            decorated.add(entry.getKey());
        }
        return decorated;
    }

    Map<MethodDescriptor, DecoratorInfo> getNextDecorators(DecoratorInfo decorator) {
        HashMap<MethodDescriptor, DecoratorInfo> next = new HashMap<MethodDescriptor, DecoratorInfo>();
        for (Map.Entry<MethodInfo, DecorationInfo> entry : this.decoratedMethods.entrySet()) {
            List<DecoratorInfo> decorators = entry.getValue().decorators;
            int index = decorators.indexOf(decorator);
            if (index == -1 || index == decorators.size() - 1) continue;
            next.put(MethodDescriptor.of((MethodInfo)entry.getKey()), decorators.get(index + 1));
        }
        return next;
    }

    InterceptionInfo getLifecycleInterceptors(InterceptionType interceptionType) {
        return this.lifecycleInterceptors.containsKey(interceptionType) ? this.lifecycleInterceptors.get(interceptionType) : InterceptionInfo.EMPTY;
    }

    public boolean hasLifecycleInterceptors() {
        return !this.lifecycleInterceptors.isEmpty();
    }

    public boolean hasAroundInvokeInterceptors() {
        return !this.interceptedMethods.isEmpty();
    }

    boolean isSubclassRequired() {
        return !this.interceptedMethods.isEmpty() || !this.decoratedMethods.isEmpty() || this.lifecycleInterceptors.containsKey(InterceptionType.PRE_DESTROY);
    }

    public boolean hasDestroyLogic() {
        if (this.isInterceptor() || this.isDecorator()) {
            return false;
        }
        if (this.disposer != null || this.destroyerConsumer != null) {
            return true;
        }
        return this.isClassBean() && (!this.getLifecycleInterceptors(InterceptionType.PRE_DESTROY).isEmpty() || !Beans.getCallbacks(this.target.get().asClass(), DotNames.PRE_DESTROY, this.beanDeployment.getBeanArchiveIndex()).isEmpty());
    }

    public boolean isForceApplicationClass() {
        return this.forceApplicationClass;
    }

    public List<InterceptorInfo> getBoundInterceptors() {
        if (this.lifecycleInterceptors.isEmpty() && this.interceptedMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InterceptorInfo> bound = new ArrayList<InterceptorInfo>();
        for (InterceptionInfo interception : this.lifecycleInterceptors.values()) {
            for (InterceptorInfo interceptor : interception.interceptors) {
                if (bound.contains(interceptor)) continue;
                bound.add(interceptor);
            }
        }
        for (InterceptionInfo interception : this.interceptedMethods.values()) {
            for (InterceptorInfo interceptor : interception.interceptors) {
                if (bound.contains(interceptor)) continue;
                bound.add(interceptor);
            }
        }
        Collections.sort(bound);
        return bound;
    }

    public List<DecoratorInfo> getBoundDecorators() {
        if (this.decoratedMethods.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DecoratorInfo> bound = new ArrayList<DecoratorInfo>();
        for (DecorationInfo decoration : this.decoratedMethods.values()) {
            for (DecoratorInfo decorator : decoration.decorators) {
                if (bound.contains(decorator)) continue;
                bound.add(decorator);
            }
        }
        Collections.sort(bound, Comparator.comparing(BeanInfo::getPriority).thenComparing(BeanInfo::getBeanClass).reversed());
        return bound;
    }

    public DisposerInfo getDisposer() {
        return this.disposer;
    }

    public boolean isAlternative() {
        return this.alternative;
    }

    public Integer getAlternativePriority() {
        return this.alternative ? this.priority : null;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public List<StereotypeInfo> getStereotypes() {
        return this.stereotypes;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultBean() {
        return this.defaultBean;
    }

    public boolean isAssignableTo(Type requiredType, AnnotationInstance ... requiredQualifiers) {
        Set<AnnotationInstance> qualifiers;
        if (requiredQualifiers.length == 0) {
            qualifiers = Collections.emptySet();
        } else {
            qualifiers = new HashSet();
            Collections.addAll(qualifiers, requiredQualifiers);
        }
        return this.beanDeployment.getBeanResolver().matches(this, requiredType, qualifiers);
    }

    Consumer<MethodCreator> getCreatorConsumer() {
        return this.creatorConsumer;
    }

    Consumer<MethodCreator> getDestroyerConsumer() {
        return this.destroyerConsumer;
    }

    Map<String, Object> getParams() {
        return this.params;
    }

    public String getTargetPackageName() {
        if (this.targetPackageName != null) {
            return this.targetPackageName;
        }
        DotName providerTypeName = this.isProducerMethod() || this.isProducerField() ? this.declaringBean.getProviderType().name() : (this.providerType.kind() == Type.Kind.ARRAY || this.providerType.kind() == Type.Kind.PRIMITIVE ? this.implClazz.name() : this.providerType.name());
        String packageName = DotNames.packageName(providerTypeName);
        if (packageName.startsWith("java.")) {
            packageName = AbstractGenerator.DEFAULT_PACKAGE;
        }
        return packageName;
    }

    public String getClientProxyPackageName() {
        if (this.isProducerField() || this.isProducerMethod()) {
            AnnotationTarget target = this.getTarget().get();
            DotName typeName = target.kind() == AnnotationTarget.Kind.FIELD ? target.asField().type().name() : target.asMethod().returnType().name();
            String packageName = DotNames.packageName(typeName);
            if (packageName.startsWith("java.")) {
                packageName = AbstractGenerator.DEFAULT_PACKAGE;
            }
            return packageName;
        }
        return this.getTargetPackageName();
    }

    void validate(List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, Set<DotName> classesReceivingNoArgsCtor) {
        Beans.validateBean(this, errors, bytecodeTransformerConsumer, classesReceivingNoArgsCtor);
    }

    void init(List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        for (Injection injection : this.injections) {
            for (InjectionPointInfo injectionPoint : injection.injectionPoints) {
                if (injectionPoint.isDelegate() && !this.isDecorator()) {
                    errors.add((Throwable)new DeploymentException(String.format("Only decorators can declare a delegate injection point: %s", this)));
                    continue;
                }
                if (injectionPoint.getType().kind() == Type.Kind.TYPE_VARIABLE) {
                    errors.add((Throwable)new DefinitionException(String.format("Type variable is not a legal injection point type: %s", injectionPoint.getTargetInfo())));
                    continue;
                }
                Beans.resolveInjectionPoint(this.beanDeployment, this, injectionPoint, errors);
            }
        }
        if (this.disposer != null) {
            this.disposer.init(errors);
        }
        this.interceptedMethods.putAll(this.initInterceptedMethods(errors, bytecodeTransformerConsumer, transformUnproxyableClasses));
        this.decoratedMethods.putAll(this.initDecoratedMethods());
        if (errors.isEmpty()) {
            this.lifecycleInterceptors.putAll(this.initLifecycleInterceptors());
        }
    }

    protected String getType() {
        if (this.isProducerMethod()) {
            return "PRODUCER METHOD";
        }
        if (this.isProducerField()) {
            return "PRODUCER FIELD";
        }
        if (this.isSynthetic()) {
            return "SYNTHETIC";
        }
        return this.target.get().kind().toString();
    }

    private Map<MethodInfo, InterceptionInfo> initInterceptedMethods(List<Throwable> errors, Consumer<BytecodeTransformer> bytecodeTransformerConsumer, boolean transformUnproxyableClasses) {
        if (!this.isInterceptor() && !this.isDecorator() && this.isClassBean()) {
            Set<MethodInfo> finalMethods;
            HashMap<MethodInfo, InterceptionInfo> interceptedMethods = new HashMap<MethodInfo, InterceptionInfo>();
            HashMap<Methods.MethodKey, Set<AnnotationInstance>> candidates = new HashMap<Methods.MethodKey, Set<AnnotationInstance>>();
            ArrayList<AnnotationInstance> classLevelBindings = new ArrayList<AnnotationInstance>();
            this.addClassLevelBindings(this.target.get().asClass(), classLevelBindings);
            if (!this.stereotypes.isEmpty()) {
                for (StereotypeInfo stereotype : this.stereotypes) {
                    this.addClassLevelBindings(stereotype.getTarget(), classLevelBindings);
                }
            }
            if (!(finalMethods = Methods.addInterceptedMethodCandidates(this.beanDeployment, this.target.get().asClass(), candidates, classLevelBindings, bytecodeTransformerConsumer, transformUnproxyableClasses)).isEmpty()) {
                errors.add((Throwable)new DeploymentException(String.format("Intercepted methods of the bean %s may not be declared final:\n\t- %s", this.getBeanClass(), finalMethods.stream().map(Object::toString).sorted().collect(Collectors.joining("\n\t- ")))));
                return Collections.emptyMap();
            }
            for (Map.Entry entry : candidates.entrySet()) {
                List<InterceptorInfo> interceptors = this.beanDeployment.getInterceptorResolver().resolve(InterceptionType.AROUND_INVOKE, (Set)entry.getValue());
                if (interceptors.isEmpty()) continue;
                interceptedMethods.put(((Methods.MethodKey)entry.getKey()).method, new InterceptionInfo(interceptors, (Set)entry.getValue()));
            }
            return interceptedMethods;
        }
        return Collections.emptyMap();
    }

    private Map<MethodInfo, DecorationInfo> initDecoratedMethods() {
        Collection<DecoratorInfo> decorators = this.beanDeployment.getDecorators();
        if (decorators.isEmpty() || this.isInterceptor() || this.isDecorator() || !this.isClassBean()) {
            return Collections.emptyMap();
        }
        ArrayList<DecoratorInfo> bound = new ArrayList<DecoratorInfo>();
        for (DecoratorInfo decorator : decorators) {
            if (!this.beanDeployment.delegateInjectionPointResolver.matches(this, decorator.getDelegateInjectionPoint().getTypeAndQualifiers())) continue;
            bound.add(decorator);
        }
        Collections.sort(bound, Comparator.comparingInt(BeanInfo::getPriority).thenComparing(BeanInfo::getBeanClass));
        HashMap<Methods.MethodKey, DecorationInfo> candidates = new HashMap<Methods.MethodKey, DecorationInfo>();
        ClassInfo classInfo = this.target.get().asClass();
        this.addDecoratedMethods(candidates, classInfo, classInfo, bound, new Methods.SubclassSkipPredicate(this.beanDeployment.getAssignabilityCheck()::isAssignableFrom, this.beanDeployment.getBeanArchiveIndex()));
        HashMap<MethodInfo, DecorationInfo> decoratedMethods = new HashMap<MethodInfo, DecorationInfo>(candidates.size());
        for (Map.Entry entry : candidates.entrySet()) {
            decoratedMethods.put(((Methods.MethodKey)entry.getKey()).method, (DecorationInfo)entry.getValue());
        }
        return decoratedMethods;
    }

    private void addDecoratedMethods(Map<Methods.MethodKey, DecorationInfo> decoratedMethods, ClassInfo classInfo, ClassInfo originalClassInfo, List<DecoratorInfo> boundDecorators, Methods.SubclassSkipPredicate skipPredicate) {
        ClassInfo superClassInfo;
        skipPredicate.startProcessing(classInfo, originalClassInfo);
        for (MethodInfo method : classInfo.methods()) {
            List<DecoratorInfo> matching;
            if (skipPredicate.test(method) || (matching = this.findMatchingDecorators(method, boundDecorators)).isEmpty()) continue;
            decoratedMethods.computeIfAbsent(new Methods.MethodKey(method), key -> new DecorationInfo(matching));
        }
        skipPredicate.methodsProcessed();
        if (!classInfo.superName().equals((Object)DotNames.OBJECT) && (superClassInfo = IndexClassLookupUtils.getClassByName(this.beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            this.addDecoratedMethods(decoratedMethods, superClassInfo, originalClassInfo, boundDecorators, skipPredicate);
        }
    }

    List<DecoratorInfo> findMatchingDecorators(MethodInfo method, List<DecoratorInfo> decorators) {
        List methodParams = method.parameterTypes();
        ArrayList<DecoratorInfo> matching = new ArrayList<DecoratorInfo>(decorators.size());
        for (DecoratorInfo decorator : decorators) {
            for (Type decoratedType : decorator.getDecoratedTypes()) {
                ClassInfo decoratedTypeClass = decorator.getDeployment().getBeanArchiveIndex().getClassByName(decoratedType.name());
                if (decoratedTypeClass == null) {
                    throw new DefinitionException("The class of the decorated type " + decoratedType + " was not found in the index");
                }
                for (MethodInfo decoratedMethod : decoratedTypeClass.methods()) {
                    if (!method.name().equals(decoratedMethod.name())) continue;
                    List<Type> decoratedMethodParams = decoratedMethod.parameterTypes();
                    if (methodParams.size() != decoratedMethodParams.size()) continue;
                    boolean matches = true;
                    decoratedMethodParams = Types.getResolvedParameters(decoratedTypeClass, method, this.beanDeployment.getBeanArchiveIndex());
                    for (int i = 0; i < methodParams.size(); ++i) {
                        if (((Type)methodParams.get(i)).equals((Object)decoratedMethodParams.get(i))) continue;
                        matches = false;
                    }
                    if (!matches) continue;
                    matching.add(decorator);
                }
            }
        }
        return matching;
    }

    private Map<InterceptionType, InterceptionInfo> initLifecycleInterceptors() {
        if (!this.isInterceptor() && this.isClassBean()) {
            HashMap<InterceptionType, InterceptionInfo> lifecycleInterceptors = new HashMap<InterceptionType, InterceptionInfo>();
            HashSet<AnnotationInstance> classLevelBindings = new HashSet<AnnotationInstance>();
            HashSet<AnnotationInstance> constructorLevelBindings = new HashSet<AnnotationInstance>();
            this.addClassLevelBindings(this.target.get().asClass(), classLevelBindings);
            this.addConstructorLevelBindings(this.target.get().asClass(), constructorLevelBindings);
            this.putLifecycleInterceptors(lifecycleInterceptors, classLevelBindings, InterceptionType.POST_CONSTRUCT);
            this.putLifecycleInterceptors(lifecycleInterceptors, classLevelBindings, InterceptionType.PRE_DESTROY);
            MethodInfo interceptedConstructor = this.findInterceptedConstructor(this.target.get().asClass());
            if (this.beanDeployment.getAnnotation((AnnotationTarget)interceptedConstructor, DotNames.NO_CLASS_INTERCEPTORS) == null) {
                constructorLevelBindings.addAll(classLevelBindings);
            }
            this.putLifecycleInterceptors(lifecycleInterceptors, constructorLevelBindings, InterceptionType.AROUND_CONSTRUCT);
            return lifecycleInterceptors;
        }
        return Collections.emptyMap();
    }

    private void putLifecycleInterceptors(Map<InterceptionType, InterceptionInfo> lifecycleInterceptors, Set<AnnotationInstance> classLevelBindings, InterceptionType interceptionType) {
        List<InterceptorInfo> interceptors = this.beanDeployment.getInterceptorResolver().resolve(interceptionType, classLevelBindings);
        if (!interceptors.isEmpty()) {
            lifecycleInterceptors.put(interceptionType, new InterceptionInfo(interceptors, classLevelBindings));
        }
    }

    private void addClassLevelBindings(ClassInfo classInfo, Collection<AnnotationInstance> bindings) {
        ClassInfo superClass;
        this.beanDeployment.getAnnotations((AnnotationTarget)classInfo).stream().filter(a -> this.beanDeployment.getInterceptorBinding(a.name()) != null && bindings.stream().noneMatch(e -> e.name().equals((Object)a.name()))).forEach(bindings::add);
        if (classInfo.superClassType() != null && !classInfo.superClassType().name().equals((Object)DotNames.OBJECT) && (superClass = IndexClassLookupUtils.getClassByName(this.beanDeployment.getBeanArchiveIndex(), classInfo.superName())) != null) {
            this.addClassLevelBindings(superClass, bindings);
        }
    }

    private MethodInfo findInterceptedConstructor(ClassInfo clazz) {
        Optional<Injection> constructorWithInject = this.getConstructorInjection();
        if (constructorWithInject.isPresent()) {
            return constructorWithInject.get().target.asMethod();
        }
        return clazz.method("<init>", new Type[0]);
    }

    private void addConstructorLevelBindings(ClassInfo classInfo, Collection<AnnotationInstance> bindings) {
        MethodInfo constructor = this.findInterceptedConstructor(classInfo);
        if (constructor != null) {
            this.beanDeployment.getAnnotations((AnnotationTarget)constructor).stream().flatMap(a -> this.beanDeployment.extractInterceptorBindings((AnnotationInstance)a).stream()).forEach(bindings::add);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType());
        builder.append(" bean [types=");
        builder.append(this.types);
        builder.append(", qualifiers=");
        builder.append(this.qualifiers);
        builder.append(", target=");
        builder.append(this.target.isPresent() ? this.target.get() : "n/a");
        if (this.declaringBean != null) {
            builder.append(", declaringBean=");
            builder.append(this.declaringBean.target.isPresent() ? this.declaringBean.target.get() : "n/a");
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanInfo other = (BeanInfo)obj;
        return Objects.equals(this.identifier, other.identifier);
    }

    private Type initProviderType(AnnotationTarget target, ClassInfo implClazz) {
        if (target != null) {
            switch (target.kind()) {
                case CLASS: {
                    return Types.getProviderType(target.asClass());
                }
                case FIELD: {
                    return target.asField().type();
                }
                case METHOD: {
                    return target.asMethod().returnType();
                }
            }
        } else if (implClazz != null) {
            return Type.create((DotName)implClazz.name(), (Type.Kind)Type.Kind.CLASS);
        }
        throw new IllegalStateException("Cannot infer the provider type");
    }

    private ClassInfo initImplClazz(AnnotationTarget target, BeanDeployment beanDeployment) {
        switch (target.kind()) {
            case CLASS: {
                return target.asClass();
            }
            case FIELD: {
                return IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), target.asField().type());
            }
            case METHOD: {
                return IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), target.asMethod().returnType());
            }
        }
        return null;
    }

    static class Builder {
        private ClassInfo implClazz;
        private Type providerType;
        private AnnotationTarget target;
        private BeanDeployment beanDeployment;
        private ScopeInfo scope;
        private Set<Type> types;
        private Set<AnnotationInstance> qualifiers;
        private List<Injection> injections = Collections.emptyList();
        private BeanInfo declaringBean;
        private DisposerInfo disposer;
        private boolean alternative;
        private List<StereotypeInfo> stereotypes = Collections.emptyList();
        private String name;
        private boolean isDefaultBean;
        private Consumer<MethodCreator> creatorConsumer;
        private Consumer<MethodCreator> destroyerConsumer;
        private Map<String, Object> params;
        private boolean removable = true;
        private boolean forceApplicationClass;
        private String targetPackageName;
        private Integer priority;

        Builder() {
        }

        Builder implClazz(ClassInfo implClazz) {
            this.implClazz = implClazz;
            return this;
        }

        Builder providerType(Type providerType) {
            this.providerType = providerType;
            return this;
        }

        Builder beanDeployment(BeanDeployment beanDeployment) {
            this.beanDeployment = beanDeployment;
            return this;
        }

        Builder target(AnnotationTarget target) {
            this.target = target;
            return this;
        }

        Builder scope(ScopeInfo scope) {
            this.scope = scope;
            return this;
        }

        Builder types(Set<Type> types) {
            this.types = types;
            return this;
        }

        Builder qualifiers(Set<AnnotationInstance> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        Builder injections(List<Injection> injections) {
            this.injections = injections;
            return this;
        }

        Builder declaringBean(BeanInfo declaringBean) {
            this.declaringBean = declaringBean;
            return this;
        }

        Builder disposer(DisposerInfo disposer) {
            this.disposer = disposer;
            return this;
        }

        Builder alternativePriority(Integer alternativePriority) {
            return this.alternative(true).priority(this.priority);
        }

        Builder alternative(boolean value) {
            this.alternative = value;
            return this;
        }

        Builder priority(Integer value) {
            this.priority = value;
            return this;
        }

        Builder stereotypes(List<StereotypeInfo> stereotypes) {
            this.stereotypes = stereotypes;
            return this;
        }

        Builder name(String name) {
            this.name = name;
            return this;
        }

        Builder defaultBean(boolean isDefaultBean) {
            this.isDefaultBean = isDefaultBean;
            return this;
        }

        Builder creator(Consumer<MethodCreator> creatorConsumer) {
            this.creatorConsumer = creatorConsumer;
            return this;
        }

        Builder destroyer(Consumer<MethodCreator> destroyerConsumer) {
            this.destroyerConsumer = destroyerConsumer;
            return this;
        }

        Builder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        Builder removable(boolean val) {
            this.removable = val;
            return this;
        }

        Builder targetPackageName(String name) {
            this.targetPackageName = name;
            return this;
        }

        BeanInfo build() {
            return new BeanInfo(this.implClazz, this.providerType, this.target, this.beanDeployment, this.scope, this.types, this.qualifiers, this.injections, this.declaringBean, this.disposer, this.alternative, this.stereotypes, this.name, this.isDefaultBean, this.creatorConsumer, this.destroyerConsumer, this.params, this.removable, this.forceApplicationClass, this.targetPackageName, this.priority);
        }

        public Builder forceApplicationClass(boolean forceApplicationClass) {
            this.forceApplicationClass = forceApplicationClass;
            return this;
        }
    }

    static class DecorationInfo {
        final List<DecoratorInfo> decorators;

        public DecorationInfo(List<DecoratorInfo> decorators) {
            this.decorators = decorators;
        }

        boolean isEmpty() {
            return this.decorators.isEmpty();
        }
    }

    static class InterceptionInfo {
        static final InterceptionInfo EMPTY = new InterceptionInfo(Collections.emptyList(), Collections.emptySet());
        final List<InterceptorInfo> interceptors;
        final Set<AnnotationInstance> bindings;

        InterceptionInfo(List<InterceptorInfo> interceptors, Set<AnnotationInstance> bindings) {
            this.interceptors = interceptors;
            this.bindings = bindings;
        }

        boolean isEmpty() {
            return this.interceptors.isEmpty();
        }
    }
}

