/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.processor.BeanDeployment;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.IndexClassLookupUtils;
import io.quarkus.arc.processor.Injection;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.InterceptionType;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class InterceptorInfo
extends BeanInfo
implements Comparable<InterceptorInfo> {
    private static final Logger LOGGER = Logger.getLogger(InterceptorInfo.class);
    private final Set<AnnotationInstance> bindings;
    private final MethodInfo aroundInvoke;
    private final MethodInfo aroundConstruct;
    private final MethodInfo postConstruct;
    private final MethodInfo preDestroy;
    private final int priority;

    InterceptorInfo(AnnotationTarget target, BeanDeployment beanDeployment, Set<AnnotationInstance> bindings, List<Injection> injections, int priority) {
        super(target, beanDeployment, BuiltinScope.DEPENDENT.getInfo(), Collections.singleton(Type.create((DotName)target.asClass().name(), (Type.Kind)Type.Kind.CLASS)), new HashSet<AnnotationInstance>(), injections, null, null, null, Collections.emptyList(), null, false);
        this.bindings = bindings;
        this.priority = priority;
        ArrayList<MethodInfo> aroundInvokes = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> aroundConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> postConstructs = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> preDestroys = new ArrayList<MethodInfo>();
        ClassInfo aClass = target.asClass();
        while (aClass != null) {
            for (MethodInfo method : aClass.methods()) {
                if (Modifier.isStatic(method.flags())) continue;
                if (method.hasAnnotation(DotNames.AROUND_INVOKE)) {
                    aroundInvokes.add(method);
                    continue;
                }
                if (method.hasAnnotation(DotNames.AROUND_CONSTRUCT)) {
                    if (!method.parameters().equals(Collections.singletonList(Type.create((DotName)DotName.createSimple((String)"javax.interceptor.InvocationContext"), (Type.Kind)Type.Kind.CLASS)))) {
                        throw new IllegalStateException("@AroundConstruct must have exactly one argument of type javax.interceptor.InvocationContext, but method " + method.asMethod() + " declared by " + method.declaringClass() + " violates this.");
                    }
                    if (!method.returnType().kind().equals((Object)Type.Kind.VOID) && !method.returnType().name().equals((Object)DotNames.OBJECT)) {
                        throw new IllegalStateException("Return type of @AroundConstruct method must be Object or void, but method " + method.asMethod() + " declared by " + method.declaringClass() + " violates this.");
                    }
                    aroundConstructs.add(method);
                    continue;
                }
                if (method.hasAnnotation(DotNames.POST_CONSTRUCT)) {
                    postConstructs.add(method);
                    continue;
                }
                if (!method.hasAnnotation(DotNames.PRE_DESTROY)) continue;
                preDestroys.add(method);
            }
            DotName superTypeName = aClass.superName();
            aClass = superTypeName == null || DotNames.OBJECT.equals((Object)superTypeName) ? null : IndexClassLookupUtils.getClassByName(beanDeployment.getBeanArchiveIndex(), superTypeName);
        }
        this.aroundInvoke = aroundInvokes.isEmpty() ? null : (MethodInfo)aroundInvokes.get(0);
        this.aroundConstruct = aroundConstructs.isEmpty() ? null : (MethodInfo)aroundConstructs.get(0);
        this.postConstruct = postConstructs.isEmpty() ? null : (MethodInfo)postConstructs.get(0);
        MethodInfo methodInfo = this.preDestroy = preDestroys.isEmpty() ? null : (MethodInfo)preDestroys.get(0);
        if (this.aroundConstruct == null && this.aroundInvoke == null && this.preDestroy == null && this.postConstruct == null) {
            LOGGER.warnf("%s declares no around-invoke method nor a lifecycle callback!", (Object)this);
        }
    }

    public Set<AnnotationInstance> getBindings() {
        return this.bindings;
    }

    public int getPriority() {
        return this.priority;
    }

    MethodInfo getAroundInvoke() {
        return this.aroundInvoke;
    }

    MethodInfo getAroundConstruct() {
        return this.aroundConstruct;
    }

    MethodInfo getPostConstruct() {
        return this.postConstruct;
    }

    MethodInfo getPreDestroy() {
        return this.preDestroy;
    }

    public boolean intercepts(InterceptionType interceptionType) {
        switch (interceptionType) {
            case AROUND_INVOKE: {
                return this.aroundInvoke != null;
            }
            case AROUND_CONSTRUCT: {
                return this.aroundConstruct != null;
            }
            case POST_CONSTRUCT: {
                return this.postConstruct != null;
            }
            case PRE_DESTROY: {
                return this.preDestroy != null;
            }
        }
        return false;
    }

    @Override
    public boolean isInterceptor() {
        return true;
    }

    @Override
    public String toString() {
        return "INTERCEPTOR bean [bindings=" + this.bindings + ", target=" + this.getTarget() + "]";
    }

    @Override
    public int compareTo(InterceptorInfo other) {
        return this.getTarget().toString().compareTo(other.getTarget().toString());
    }
}

