/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.metrics;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.metrics.HistogramDataPointMarshaler;
import io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import io.opentelemetry.proto.metrics.v1.internal.Histogram;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import java.io.IOException;

final class HistogramMarshaler
extends MarshalerWithSize {
    private final HistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static HistogramMarshaler create(HistogramData histogram) {
        HistogramDataPointMarshaler[] dataPointMarshalers = HistogramDataPointMarshaler.createRepeated(histogram.getPoints());
        return new HistogramMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    private HistogramMarshaler(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        super(HistogramMarshaler.calculateSize(dataPoints, aggregationTemporality));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
    }

    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Histogram.DATA_POINTS, (Marshaler[])this.dataPoints);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Histogram.DATA_POINTS, (Marshaler[])dataPoints);
        return size += MarshalerUtil.sizeEnum((ProtoFieldInfo)Histogram.AGGREGATION_TEMPORALITY, (ProtoEnumInfo)aggregationTemporality);
    }
}

