/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

final class SqlCommenterUtil {
    public static String processQuery(String query, TextMapPropagator propagator, boolean prepend) {
        if (!Span.current().getSpanContext().isValid()) {
            return query;
        }
        if (SqlCommenterUtil.containsSqlComment(query)) {
            return query;
        }
        LinkedHashMap state = new LinkedHashMap();
        propagator.inject(Context.current(), state, (carrier, key, value) -> {
            if (carrier == null) {
                return;
            }
            carrier.put(key, value);
        });
        if (state.isEmpty()) {
            return query;
        }
        StringBuilder stringBuilder = new StringBuilder("/*");
        try {
            Iterator iterator = state.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                stringBuilder.append(SqlCommenterUtil.serialize((String)entry.getKey())).append("='").append(SqlCommenterUtil.serialize((String)entry.getValue())).append("'");
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        stringBuilder.append("*/");
        return prepend ? stringBuilder + " " + query : query + " " + stringBuilder;
    }

    private static boolean containsSqlComment(String query) {
        return query.contains("--") || query.contains("/*");
    }

    private static String serialize(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20");
    }

    private SqlCommenterUtil() {
    }
}

