/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.charts.highcharts.template;

import io.gatling.charts.highcharts.series.NumberPerSecondSeries;
import io.gatling.charts.highcharts.template.Template;
import io.gatling.charts.highcharts.template.Template$;
import io.gatling.charts.util.Color;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t3Qa\u0002\u0005\u0003\u0015IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\t?\u0001\u0011\t\u0011)A\u0005A!)\u0011\u0007\u0001C\u0001e!)a\u0007\u0001C!o!9\u0001\t\u0001b\u0001\n\u0003:\u0004BB!\u0001A\u0003%\u0001HA\nBGRLg/Z+tKJ\u001cH+Z7qY\u0006$XM\u0003\u0002\n\u0015\u0005AA/Z7qY\u0006$XM\u0003\u0002\f\u0019\u0005Q\u0001.[4iG\"\f'\u000f^:\u000b\u00055q\u0011AB2iCJ$8O\u0003\u0002\u0010!\u00059q-\u0019;mS:<'\"A\t\u0002\u0005%|7C\u0001\u0001\u0014!\t!R#D\u0001\t\u0013\t1\u0002B\u0001\u0005UK6\u0004H.\u0019;f\u0003!\u0011XO\\*uCJ$8\u0001\u0001\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0005\u0019>tw-\u0001\u0004tKJLWm\u001d\t\u0004C%bcB\u0001\u0012(\u001d\t\u0019c%D\u0001%\u0015\t)\u0003$\u0001\u0004=e>|GOP\u0005\u00029%\u0011\u0001fG\u0001\ba\u0006\u001c7.Y4f\u0013\tQ3FA\u0002TKFT!\u0001K\u000e\u0011\u00055zS\"\u0001\u0018\u000b\u0005}Q\u0011B\u0001\u0019/\u0005UqU/\u001c2feB+'oU3d_:$7+\u001a:jKN\fa\u0001P5oSRtDcA\u001a5kA\u0011A\u0003\u0001\u0005\u0006/\r\u0001\r!\u0007\u0005\u0006?\r\u0001\r\u0001I\u0001\u0003UN,\u0012\u0001\u000f\t\u0003sur!AO\u001e\u0011\u0005\rZ\u0012B\u0001\u001f\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qZ\u0012\u0001\u00025u[2\fQ\u0001\u001b;nY\u0002\u0002")
public final class ActiveUsersTemplate
extends Template {
    private final long runStart;
    private final Seq<NumberPerSecondSeries> series;
    private final String html;

    @Override
    public String js() {
        return new StringBuilder(1720).append("\nallUsersData.yAxis = 0;\n\nvar allUsersChart = new Highcharts.StockChart({\n  chart: {\n    renderTo: 'active_users',\n    zoomType: 'x'\n  },\n  credits: { enabled: false },\n  legend: {\n    enabled: true,\n    floating: true,\n    align: 'right',\n    verticalAlign: 'top',\n    layout: 'vertical',\n    borderWidth: 0,\n    itemStyle: { fontWeight: \"normal\" },\n    symbolRadius: 0\n  },\n  title: { text: 'A title to let highcharts reserve the place for the title set later' },\n  navigator: {\n    maskInside: false\n  },\n  rangeSelector: {\n    buttonSpacing: 0,\n    buttonTheme: {\n      fill: '").append(Color.RangeSelector$.Fill$.MODULE$).append("',\n      padding: 1,\n      stroke: '").append(Color.RangeSelector$.Border$.MODULE$).append("',\n      'stroke-width': 0.25,\n      style: {\n        color: '").append(Color.RangeSelector$.Border$.MODULE$).append("',\n        fontWeight: 'bold',\n      },\n      states: {\n        stroke: '").append(Color.RangeSelector$.Border$.MODULE$).append("',\n        'stroke-width': 0.25,\n        hover: {\n          fill: '").append(Color.RangeSelector$.Hover$.MODULE$).append("',\n          style: { color: 'black' }\n        },\n        select: {\n          fill: '").append(Color.RangeSelector$.MODULE$.Selected()).append("',\n          style: { color: 'white' }\n        }\n      }\n    },\n    buttons : [\n      {\n        type : 'minute',\n        count : 1,\n        text : '1m'\n      }, {\n        type : 'minute',\n        count : 10,\n        text : '10m'\n      }, {\n        type : 'hour',\n        count : 1,\n        text : '1h'\n      }, {\n        type : 'all',\n        count : 1,\n        text : 'All'\n      }\n    ],\n    selected : 3,\n    inputEnabled : false\n  },\n  xAxis: {\n    type: 'datetime',\n    ordinal: false,\n    maxZoom: 10000 // three days\n  },\n  yAxis: {\n    title: { text: 'Number of Active Users' },\n    opposite: false,\n    min: 0\n  },\n  series: [\n    ").append(((IterableOnceOps)this.series.flatMap((Function1 & Serializable)serie -> (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"{", Template$.MODULE$.renderUsersPerSecondSeries($this.runStart, (NumberPerSecondSeries)serie), "},\n"})))).mkString()).append("\n    allUsersData\n  ]\n});\n\n\nallUsersChart.setTitle({\n  text: '<span class=\"chart_title\">Active Users along the Simulation</span>',\n  useHTML: true\n});\n\nallUsersData.yAxis = 1;\n").toString();
    }

    @Override
    public String html() {
        return this.html;
    }

    public ActiveUsersTemplate(long runStart, Seq<NumberPerSecondSeries> series) {
        this.runStart = runStart;
        this.series = series;
        this.html = "\n            <div class=\"schema geant\">\n              <div id=\"active_users\" class=\"geant\"></div>\n            </div>\n";
    }
}

