/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.AzureProviderSpec;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBinding;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBindingBuilder;
import io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1.RoleBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AzureProviderSpecFluent<A extends AzureProviderSpecFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String azureClientID;
    private String azureRegion;
    private String azureSubscriptionID;
    private String azureTenantID;
    private List<String> dataPermissions = new ArrayList<String>();
    private String kind;
    private List<String> permissions = new ArrayList<String>();
    private ArrayList<RoleBindingBuilder> roleBindings = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AzureProviderSpecFluent() {
    }

    public AzureProviderSpecFluent(AzureProviderSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AzureProviderSpec instance) {
        AzureProviderSpec azureProviderSpec = instance = instance != null ? instance : new AzureProviderSpec();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAzureClientID(instance.getAzureClientID());
            this.withAzureRegion(instance.getAzureRegion());
            this.withAzureSubscriptionID(instance.getAzureSubscriptionID());
            this.withAzureTenantID(instance.getAzureTenantID());
            this.withDataPermissions(instance.getDataPermissions());
            this.withKind(instance.getKind());
            this.withPermissions(instance.getPermissions());
            this.withRoleBindings(instance.getRoleBindings());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getAzureClientID() {
        return this.azureClientID;
    }

    public A withAzureClientID(String azureClientID) {
        this.azureClientID = azureClientID;
        return (A)((Object)this);
    }

    public boolean hasAzureClientID() {
        return this.azureClientID != null;
    }

    public String getAzureRegion() {
        return this.azureRegion;
    }

    public A withAzureRegion(String azureRegion) {
        this.azureRegion = azureRegion;
        return (A)((Object)this);
    }

    public boolean hasAzureRegion() {
        return this.azureRegion != null;
    }

    public String getAzureSubscriptionID() {
        return this.azureSubscriptionID;
    }

    public A withAzureSubscriptionID(String azureSubscriptionID) {
        this.azureSubscriptionID = azureSubscriptionID;
        return (A)((Object)this);
    }

    public boolean hasAzureSubscriptionID() {
        return this.azureSubscriptionID != null;
    }

    public String getAzureTenantID() {
        return this.azureTenantID;
    }

    public A withAzureTenantID(String azureTenantID) {
        this.azureTenantID = azureTenantID;
        return (A)((Object)this);
    }

    public boolean hasAzureTenantID() {
        return this.azureTenantID != null;
    }

    public A addToDataPermissions(int index, String item) {
        if (this.dataPermissions == null) {
            this.dataPermissions = new ArrayList<String>();
        }
        this.dataPermissions.add(index, item);
        return (A)((Object)this);
    }

    public A setToDataPermissions(int index, String item) {
        if (this.dataPermissions == null) {
            this.dataPermissions = new ArrayList<String>();
        }
        this.dataPermissions.set(index, item);
        return (A)((Object)this);
    }

    public A addToDataPermissions(String ... items) {
        if (this.dataPermissions == null) {
            this.dataPermissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.dataPermissions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDataPermissions(Collection<String> items) {
        if (this.dataPermissions == null) {
            this.dataPermissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.dataPermissions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDataPermissions(String ... items) {
        if (this.dataPermissions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dataPermissions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDataPermissions(Collection<String> items) {
        if (this.dataPermissions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dataPermissions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDataPermissions() {
        return this.dataPermissions;
    }

    public String getDataPermission(int index) {
        return this.dataPermissions.get(index);
    }

    public String getFirstDataPermission() {
        return this.dataPermissions.get(0);
    }

    public String getLastDataPermission() {
        return this.dataPermissions.get(this.dataPermissions.size() - 1);
    }

    public String getMatchingDataPermission(Predicate<String> predicate) {
        for (String item : this.dataPermissions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDataPermission(Predicate<String> predicate) {
        for (String item : this.dataPermissions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDataPermissions(List<String> dataPermissions) {
        if (dataPermissions != null) {
            this.dataPermissions = new ArrayList<String>();
            for (String item : dataPermissions) {
                this.addToDataPermissions(item);
            }
        } else {
            this.dataPermissions = null;
        }
        return (A)((Object)this);
    }

    public A withDataPermissions(String ... dataPermissions) {
        if (this.dataPermissions != null) {
            this.dataPermissions.clear();
            this._visitables.remove((Object)"dataPermissions");
        }
        if (dataPermissions != null) {
            for (String item : dataPermissions) {
                this.addToDataPermissions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDataPermissions() {
        return this.dataPermissions != null && !this.dataPermissions.isEmpty();
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public A addToPermissions(int index, String item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.add(index, item);
        return (A)((Object)this);
    }

    public A setToPermissions(int index, String item) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        this.permissions.set(index, item);
        return (A)((Object)this);
    }

    public A addToPermissions(String ... items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.permissions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPermissions(Collection<String> items) {
        if (this.permissions == null) {
            this.permissions = new ArrayList<String>();
        }
        for (String item : items) {
            this.permissions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPermissions(String ... items) {
        if (this.permissions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.permissions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPermissions(Collection<String> items) {
        if (this.permissions == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.permissions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public String getPermission(int index) {
        return this.permissions.get(index);
    }

    public String getFirstPermission() {
        return this.permissions.get(0);
    }

    public String getLastPermission() {
        return this.permissions.get(this.permissions.size() - 1);
    }

    public String getMatchingPermission(Predicate<String> predicate) {
        for (String item : this.permissions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPermission(Predicate<String> predicate) {
        for (String item : this.permissions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPermissions(List<String> permissions) {
        if (permissions != null) {
            this.permissions = new ArrayList<String>();
            for (String item : permissions) {
                this.addToPermissions(item);
            }
        } else {
            this.permissions = null;
        }
        return (A)((Object)this);
    }

    public A withPermissions(String ... permissions) {
        if (this.permissions != null) {
            this.permissions.clear();
            this._visitables.remove((Object)"permissions");
        }
        if (permissions != null) {
            for (String item : permissions) {
                this.addToPermissions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPermissions() {
        return this.permissions != null && !this.permissions.isEmpty();
    }

    public A addToRoleBindings(int index, RoleBinding item) {
        if (this.roleBindings == null) {
            this.roleBindings = new ArrayList();
        }
        RoleBindingBuilder builder = new RoleBindingBuilder(item);
        if (index < 0 || index >= this.roleBindings.size()) {
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.add(builder);
        } else {
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRoleBindings(int index, RoleBinding item) {
        if (this.roleBindings == null) {
            this.roleBindings = new ArrayList();
        }
        RoleBindingBuilder builder = new RoleBindingBuilder(item);
        if (index < 0 || index >= this.roleBindings.size()) {
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.add(builder);
        } else {
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRoleBindings(RoleBinding ... items) {
        if (this.roleBindings == null) {
            this.roleBindings = new ArrayList();
        }
        for (RoleBinding item : items) {
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRoleBindings(Collection<RoleBinding> items) {
        if (this.roleBindings == null) {
            this.roleBindings = new ArrayList();
        }
        for (RoleBinding item : items) {
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            this._visitables.get((Object)"roleBindings").add(builder);
            this.roleBindings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRoleBindings(RoleBinding ... items) {
        if (this.roleBindings == null) {
            return (A)((Object)this);
        }
        for (RoleBinding item : items) {
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            this._visitables.get((Object)"roleBindings").remove((Object)builder);
            this.roleBindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRoleBindings(Collection<RoleBinding> items) {
        if (this.roleBindings == null) {
            return (A)((Object)this);
        }
        for (RoleBinding item : items) {
            RoleBindingBuilder builder = new RoleBindingBuilder(item);
            this._visitables.get((Object)"roleBindings").remove((Object)builder);
            this.roleBindings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRoleBindings(Predicate<RoleBindingBuilder> predicate) {
        if (this.roleBindings == null) {
            return (A)((Object)this);
        }
        Iterator<RoleBindingBuilder> each = this.roleBindings.iterator();
        List visitables = this._visitables.get((Object)"roleBindings");
        while (each.hasNext()) {
            RoleBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RoleBinding> buildRoleBindings() {
        return this.roleBindings != null ? AzureProviderSpecFluent.build(this.roleBindings) : null;
    }

    public RoleBinding buildRoleBinding(int index) {
        return this.roleBindings.get(index).build();
    }

    public RoleBinding buildFirstRoleBinding() {
        return this.roleBindings.get(0).build();
    }

    public RoleBinding buildLastRoleBinding() {
        return this.roleBindings.get(this.roleBindings.size() - 1).build();
    }

    public RoleBinding buildMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
        for (RoleBindingBuilder item : this.roleBindings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
        for (RoleBindingBuilder item : this.roleBindings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRoleBindings(List<RoleBinding> roleBindings) {
        if (this.roleBindings != null) {
            this._visitables.get((Object)"roleBindings").clear();
        }
        if (roleBindings != null) {
            this.roleBindings = new ArrayList();
            for (RoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        } else {
            this.roleBindings = null;
        }
        return (A)((Object)this);
    }

    public A withRoleBindings(RoleBinding ... roleBindings) {
        if (this.roleBindings != null) {
            this.roleBindings.clear();
            this._visitables.remove((Object)"roleBindings");
        }
        if (roleBindings != null) {
            for (RoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRoleBindings() {
        return this.roleBindings != null && !this.roleBindings.isEmpty();
    }

    public A addNewRoleBinding(String role) {
        return this.addToRoleBindings(new RoleBinding(role));
    }

    public RoleBindingsNested<A> addNewRoleBinding() {
        return new RoleBindingsNested(-1, null);
    }

    public RoleBindingsNested<A> addNewRoleBindingLike(RoleBinding item) {
        return new RoleBindingsNested(-1, item);
    }

    public RoleBindingsNested<A> setNewRoleBindingLike(int index, RoleBinding item) {
        return new RoleBindingsNested(index, item);
    }

    public RoleBindingsNested<A> editRoleBinding(int index) {
        if (this.roleBindings.size() <= index) {
            throw new RuntimeException("Can't edit roleBindings. Index exceeds size.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    public RoleBindingsNested<A> editFirstRoleBinding() {
        if (this.roleBindings.size() == 0) {
            throw new RuntimeException("Can't edit first roleBindings. The list is empty.");
        }
        return this.setNewRoleBindingLike(0, this.buildRoleBinding(0));
    }

    public RoleBindingsNested<A> editLastRoleBinding() {
        int index = this.roleBindings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last roleBindings. The list is empty.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    public RoleBindingsNested<A> editMatchingRoleBinding(Predicate<RoleBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.roleBindings.size(); ++i) {
            if (!predicate.test(this.roleBindings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching roleBindings. No match found.");
        }
        return this.setNewRoleBindingLike(index, this.buildRoleBinding(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureProviderSpecFluent that = (AzureProviderSpecFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.azureClientID, that.azureClientID)) {
            return false;
        }
        if (!Objects.equals(this.azureRegion, that.azureRegion)) {
            return false;
        }
        if (!Objects.equals(this.azureSubscriptionID, that.azureSubscriptionID)) {
            return false;
        }
        if (!Objects.equals(this.azureTenantID, that.azureTenantID)) {
            return false;
        }
        if (!Objects.equals(this.dataPermissions, that.dataPermissions)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.permissions, that.permissions)) {
            return false;
        }
        if (!Objects.equals(this.roleBindings, that.roleBindings)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.azureClientID, this.azureRegion, this.azureSubscriptionID, this.azureTenantID, this.dataPermissions, this.kind, this.permissions, this.roleBindings, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.azureClientID != null) {
            sb.append("azureClientID:");
            sb.append(this.azureClientID + ",");
        }
        if (this.azureRegion != null) {
            sb.append("azureRegion:");
            sb.append(this.azureRegion + ",");
        }
        if (this.azureSubscriptionID != null) {
            sb.append("azureSubscriptionID:");
            sb.append(this.azureSubscriptionID + ",");
        }
        if (this.azureTenantID != null) {
            sb.append("azureTenantID:");
            sb.append(this.azureTenantID + ",");
        }
        if (this.dataPermissions != null && !this.dataPermissions.isEmpty()) {
            sb.append("dataPermissions:");
            sb.append(String.valueOf(this.dataPermissions) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.permissions != null && !this.permissions.isEmpty()) {
            sb.append("permissions:");
            sb.append(String.valueOf(this.permissions) + ",");
        }
        if (this.roleBindings != null && !this.roleBindings.isEmpty()) {
            sb.append("roleBindings:");
            sb.append(String.valueOf(this.roleBindings) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RoleBindingsNested<N>
    extends RoleBindingFluent<RoleBindingsNested<N>>
    implements Nested<N> {
        RoleBindingBuilder builder;
        int index;

        RoleBindingsNested(int index, RoleBinding item) {
            this.index = index;
            this.builder = new RoleBindingBuilder(this, item);
        }

        public N and() {
            return (N)AzureProviderSpecFluent.this.setToRoleBindings(this.index, this.builder.build());
        }

        public N endRoleBinding() {
            return this.and();
        }
    }
}

