/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.merge;

import io.fabric8.maven.merge.SortedProperties;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.apache.maven.model.merge.ModelMerger;

public class SmartModelMerger
extends ModelMerger {
    protected Object getDependencyKey(Dependency dependency) {
        return dependency.getGroupId() + ":" + dependency.getArtifactId();
    }

    protected void mergeModelBase_Properties(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        SortedProperties merged = new SortedProperties();
        if (sourceDominant) {
            merged.putAll((Map<?, ?>)target.getProperties());
            merged.putAll((Map<?, ?>)source.getProperties());
        } else {
            merged.putAll((Map<?, ?>)source.getProperties());
            merged.putAll((Map<?, ?>)target.getProperties());
        }
        target.setProperties((Properties)merged);
        target.setLocation((Object)"properties", InputLocation.merge((InputLocation)target.getLocation((Object)"properties"), (InputLocation)source.getLocation((Object)"properties"), (boolean)sourceDominant));
    }

    protected Object getProfileKey(Profile profile) {
        return profile.getId();
    }

    protected void mergeModelBase_Modules(ModelBase target, ModelBase source, boolean sourceDominant, Map<Object, Object> context) {
        LinkedHashSet set = new LinkedHashSet();
        set.addAll(source.getModules());
        set.addAll(target.getModules());
        target.setModules(new ArrayList(set));
    }

    protected void mergeModel_Profiles(Model target, Model source, boolean sourceDominant, Map<Object, Object> context) {
        List src = source.getProfiles();
        if (!src.isEmpty()) {
            Object key;
            List tgt = target.getProfiles();
            LinkedHashMap<Object, Profile> merged = new LinkedHashMap<Object, Profile>((src.size() + tgt.size()) * 2);
            for (Profile element : tgt) {
                key = this.getProfileKey(element);
                merged.put(key, element);
            }
            for (Profile element : src) {
                key = this.getProfileKey(element);
                if (!sourceDominant && merged.containsKey(key)) continue;
                Profile targetProfile = (Profile)merged.get(key);
                if (targetProfile != null) {
                    this.mergeProfile(targetProfile, element, sourceDominant, context);
                    merged.put(key, targetProfile);
                    continue;
                }
                merged.put(key, element);
            }
            target.setProfiles(new ArrayList(merged.values()));
        }
    }
}

