/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.junit.jupiter;

import io.fabric8.junit.jupiter.api.RequireK8sVersionAtLeast;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.VersionInfo;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class RequireK8sVersionAtLeastCondition
implements ExecutionCondition {
    public static final String NON_NUMERIC_CHARACTERS = "[^\\d.]";

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        RequireK8sVersionAtLeast requireK8s = AnnotationSupport.findAnnotation((Optional)context.getElement(), RequireK8sVersionAtLeast.class).orElse(null);
        if (requireK8s != null) {
            int minorVersion;
            int majorVersion = requireK8s.majorVersion();
            if (this.kubernetesVersionAtLeast(majorVersion, minorVersion = requireK8s.minorVersion())) {
                return ConditionEvaluationResult.enabled((String)String.format("Kubernetes version is at least %s.%s", majorVersion, minorVersion));
            }
            return ConditionEvaluationResult.disabled((String)String.format("Kubernetes version is below %s.%s", majorVersion, minorVersion));
        }
        return ConditionEvaluationResult.enabled((String)"RequireK8sVersionAtLeastCondition is not applicable");
    }

    boolean kubernetesVersionAtLeast(int majorVersion, int minorVersion) {
        try (KubernetesClient client = new KubernetesClientBuilder().build();){
            VersionInfo versionInfo = client.getKubernetesVersion();
            String clusterMajorVersion = versionInfo.getMajor().replaceAll(NON_NUMERIC_CHARACTERS, "");
            String clusterMinorVersion = versionInfo.getMinor().replaceAll(NON_NUMERIC_CHARACTERS, "");
            if (majorVersion < Integer.parseInt(clusterMajorVersion)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = Integer.parseInt(clusterMajorVersion) >= majorVersion && Integer.parseInt(clusterMinorVersion) >= minorVersion;
            return bl;
        }
    }
}

