/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model.parser;

import com.google.common.base.Charsets;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import fr.reseaumexico.model.MexicoTechnicalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.ParseException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class XmlParser<M> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M getModel(File file) throws XmlPullParserException, IOException, ParseException {
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = factory.newPullParser();
            parser.setInput((Reader)reader);
            M result = this.parseModel(parser);
            ((Reader)reader).close();
            M m = result;
            return m;
        }
        finally {
            Closeables.closeQuietly((Reader)reader);
        }
    }

    protected abstract M parseModel(XmlPullParser var1) throws IOException, XmlPullParserException, ParseException;

    public boolean parserEqual(XmlPullParser parser, String name) {
        String tagName = parser.getName();
        return tagName.equals(name);
    }

    protected void checkStartFile(XmlPullParser parser, String requiredTag, String errorMessage) throws IOException, XmlPullParserException {
        if (parser.next() == 2 && !this.parserEqual(parser, requiredTag)) {
            throw new MexicoTechnicalException(errorMessage);
        }
    }

    protected boolean testNextStartTag(XmlPullParser parser, String requiredTag) throws IOException, XmlPullParserException {
        return parser.nextTag() == 2 && this.parserEqual(parser, requiredTag);
    }

    protected boolean testNextEndTag(XmlPullParser parser, String requiredTag) throws IOException, XmlPullParserException {
        return parser.nextTag() == 3 && this.parserEqual(parser, requiredTag);
    }

    protected boolean testCurrentEndTag(XmlPullParser parser, String requiredTag) throws IOException, XmlPullParserException {
        return parser.getEventType() == 3 && this.parserEqual(parser, requiredTag);
    }

    protected boolean testCurrentStartTag(XmlPullParser parser, String requiredTag) throws IOException, XmlPullParserException {
        return parser.getEventType() == 2 && this.parserEqual(parser, requiredTag);
    }
}

