/*
 * Decompiled with CFR 0.152.
 */
package fr.reseaumexico.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.reseaumexico.model.InputDesign;
import fr.reseaumexico.model.Scenario;
import fr.reseaumexico.model.event.InputDesignFactorEvent;
import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioEvent;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import fr.reseaumexico.model.event.ScenarioFactorValueEvent;
import fr.reseaumexico.model.event.ScenarioFactorValueListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class InputDesignImpl
extends InputDesign {
    private static final long serialVersionUID = 1L;
    protected final EventListenerList listenerList;
    protected final Map<Scenario, ScenarioFactorValueListener> scenarioFactorValueListenerMap = Maps.newHashMap();

    public InputDesignImpl() {
        this.listenerList = new EventListenerList();
        this.addPropertyChangeListener("scenario", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Scenario newValue = (Scenario)((Object)propertyChangeEvent.getNewValue());
                Scenario oldValue = (Scenario)((Object)propertyChangeEvent.getOldValue());
                if (newValue == null) {
                    InputDesignImpl.this.fireInputDesignScenarioRemoved(oldValue);
                }
                if (oldValue == null) {
                    InputDesignImpl.this.fireInputDesignScenarioAdded(newValue);
                }
            }
        });
    }

    @Override
    public void addScenario(final Scenario scenarios) {
        if (this.scenario == null) {
            this.scenario = Lists.newArrayList();
        }
        super.addScenario(scenarios);
        ScenarioFactorValueListener scenarioFactorValueListener = new ScenarioFactorValueListener(){

            @Override
            public void factorValueChanged(ScenarioFactorValueEvent event) {
                InputDesignImpl.this.fireFactorChanged(scenarios, event.getFactorId(), event.getFactorOldValue(), event.getFactorNewValue());
            }
        };
        this.scenarioFactorValueListenerMap.put(scenarios, scenarioFactorValueListener);
        scenarios.addFactorValueListener(scenarioFactorValueListener);
    }

    @Override
    public void renameScenario(Scenario scenario, String newName) {
        scenario.setName(newName);
        this.fireInputDesignScenarioRenamed(scenario);
    }

    @Override
    public void addAllScenario(Collection<Scenario> scenarios) {
        for (Scenario scenario : scenarios) {
            this.addScenario(scenario);
        }
    }

    @Override
    public void setScenario(Collection<Scenario> scenarios) {
        this.addAllScenario(scenarios);
    }

    @Override
    public boolean removeScenario(Scenario scenario) {
        scenario.removeFactorValueListener(this.scenarioFactorValueListenerMap.get((Object)scenario));
        this.scenarioFactorValueListenerMap.remove((Object)scenario);
        return super.removeScenario(scenario);
    }

    @Override
    public boolean removeAllScenario(Collection<Scenario> scenarios) {
        boolean removed = false;
        for (Scenario scenario : scenarios) {
            removed = this.removeScenario(scenario);
        }
        return removed;
    }

    @Override
    public void addInputDesignScenarioListener(InputDesignScenarioListener scenarioListener) {
        this.listenerList.add(InputDesignScenarioListener.class, scenarioListener);
    }

    @Override
    public void removeInputDesignScenarioListener(InputDesignScenarioListener scenarioListener) {
        this.listenerList.remove(InputDesignScenarioListener.class, scenarioListener);
    }

    @Override
    public void addInputDesignFactorListener(InputDesignFactorListener factorListener) {
        this.listenerList.add(InputDesignFactorListener.class, factorListener);
    }

    @Override
    public void removeInputDesignFactorListener(InputDesignFactorListener factorListener) {
        this.listenerList.remove(InputDesignFactorListener.class, factorListener);
    }

    protected void fireInputDesignScenarioAdded(Scenario scenario) {
        InputDesignScenarioListener[] listeners;
        InputDesignScenarioEvent event = new InputDesignScenarioEvent(this, scenario);
        for (InputDesignScenarioListener listener : listeners = (InputDesignScenarioListener[])this.listenerList.getListeners(InputDesignScenarioListener.class)) {
            listener.scenarioAdded(event);
        }
    }

    protected void fireInputDesignScenarioRenamed(Scenario scenario) {
        InputDesignScenarioListener[] listeners;
        InputDesignScenarioEvent event = new InputDesignScenarioEvent(this, scenario);
        for (InputDesignScenarioListener listener : listeners = (InputDesignScenarioListener[])this.listenerList.getListeners(InputDesignScenarioListener.class)) {
            listener.scenarioRenamed(event);
        }
    }

    protected void fireInputDesignScenarioRemoved(Scenario scenario) {
        InputDesignScenarioListener[] listeners;
        InputDesignScenarioEvent event = new InputDesignScenarioEvent(this, scenario);
        for (InputDesignScenarioListener listener : listeners = (InputDesignScenarioListener[])this.listenerList.getListeners(InputDesignScenarioListener.class)) {
            listener.scenarioRemoved(event);
        }
    }

    protected void fireFactorChanged(Scenario scenario, String factorId, Object oldValue, Object newValue) {
        InputDesignFactorListener[] listeners;
        InputDesignFactorEvent event = new InputDesignFactorEvent(this, scenario, factorId, oldValue, newValue);
        for (InputDesignFactorListener listener : listeners = (InputDesignFactorListener[])this.listenerList.getListeners(InputDesignFactorListener.class)) {
            listener.factorValueChanged(event);
        }
    }
}

