/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.registry;

import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.discovery.ITemplateEngineDiscovery;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngineRegistry
extends AbstractRegistry<ITemplateEngineDiscovery>
implements Serializable {
    private static final long serialVersionUID = -7686229087661483932L;
    private static final TemplateEngineRegistry INSTANCE = new TemplateEngineRegistry();
    private final Map<String, ITemplateEngine> templateEnginesCache = new HashMap<String, ITemplateEngine>();
    private final Map<String, ITemplateEngineDiscovery> templateEnginesDiscoveryCache = new HashMap<String, ITemplateEngineDiscovery>();
    private ITemplateEngine defaultTemplateEngine;
    private final Collection<String> templateEngineKinds = new ArrayList<String>();

    public static TemplateEngineRegistry getRegistry() {
        return INSTANCE;
    }

    public TemplateEngineRegistry() {
        super(ITemplateEngineDiscovery.class);
    }

    protected boolean registerInstance(ITemplateEngineDiscovery instance) {
        ITemplateEngineDiscovery discovery = instance;
        this.templateEnginesDiscoveryCache.put(discovery.getId(), discovery);
        ITemplateEngine templateEngine = discovery.createTemplateEngine();
        this.register(templateEngine);
        return true;
    }

    private void register(ITemplateEngine templateEngine) {
        this.templateEnginesCache.put(templateEngine.getKind(), templateEngine);
    }

    public boolean isDefault(ITemplateEngine templateEngine) {
        this.initializeIfNeeded();
        if (templateEngine == null) {
            return false;
        }
        return templateEngine.equals(this.defaultTemplateEngine);
    }

    public ITemplateEngine getDefaultTemplateEngine() {
        this.initializeIfNeeded();
        return this.defaultTemplateEngine;
    }

    public void setDefaultTemplateEngine(ITemplateEngine defaultTemplateEngine) {
        this.defaultTemplateEngine = defaultTemplateEngine;
    }

    public Collection<ITemplateEngine> getTemplateEngines() {
        this.initializeIfNeeded();
        return this.templateEnginesCache.values();
    }

    public Collection<String> getTemplateEngineKinds() {
        this.initializeIfNeeded();
        return this.templateEnginesCache.keySet();
    }

    public Map<String, ITemplateEngineDiscovery> getTemplateEnginesDiscoveryCache() {
        this.initializeIfNeeded();
        return this.templateEnginesDiscoveryCache;
    }

    protected void doDispose() {
        this.templateEnginesDiscoveryCache.clear();
        this.defaultTemplateEngine = null;
        this.templateEngineKinds.clear();
    }

    public ITemplateEngine getTemplateEngine(TemplateEngineKind kind) {
        return this.getTemplateEngine(kind.name());
    }

    public ITemplateEngine getTemplateEngine(String kind) {
        return this.templateEnginesCache.get(kind);
    }
}

