package fr.onema.sispea.struts.synthesis.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.IndicatorValueDto;
import fr.onema.sispea.service.data.SliceDto;
import fr.onema.sispea.service.data.Verification;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.synthesis.bean.BoxAndWhiskerChartBean;
import fr.onema.sispea.struts.synthesis.bean.BoxAndWhiskerValueBean;
import fr.onema.sispea.struts.synthesis.bean.SynthesisChartType;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * This action displays the box and whisker synthesis pages.
 *
 * @author CS
 */
public class ShowChartSynthesisAction extends AbstractSynthesisAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowChartSynthesisAction.class);

    private static final int BOXANDWHISKER_CHART_WIDTH = 750;

    private static final int BOXANDWHISKER_CHART_HEIGHT = 400;

    private static final int BOXANDWHISKER_CHART_SERIES_COUNT = 15;

    /**
     * the graph type
     */
    protected SynthesisChartType chartType;

    protected boolean choosenIndicatorVisible;

    /**
     * Store the criterion name for each criteria from {@link #getCriteria()} method. Keys are translation key
     */
    protected Map<String, String> criterionNameMap;

    @Override
    protected String doExecute() throws Exception {

        //init
        String lRes = Action.SUCCESS;


        if (logger.isDebugEnabled()) {
            logger.debug("chart synthesis");
        }

        // default menu
        openMenu(MenuConstants.MENU_KEY_TYPOLOGY);

        try {

            // check chart type
            if (chartType == null) {
                throw new SispeaException("fr.onema.sispea.struts.synthesis.action.chartSynthesis.error.wrongChartType");
            }

            // check parameters
            checkAndGetParameters(false, true);

            // check parameters
            if (criterion == null) {
                throw new SispeaException("fr.onema.sispea.struts.synthesis.action.chartSynthesis.error.wrongCriterion");
            }
            if (chartType == SynthesisChartType.Scatter && slice == null) {
                throw new SispeaException("fr.onema.sispea.struts.synthesis.action.chartSynthesis.error.wrongSlice");
            }
            // which chart to display
            if (chartType == SynthesisChartType.Category) {
                processBarChart(exercise, indicator, slicesConsolidatedValues, false);
            } else if (chartType == SynthesisChartType.Scatter) {
                processScatterChart(slice, false);
            } else {
                processBoxAndWhiskerChart(slices);
            }

        } catch (SispeaException lEx) {
            lRes = Action.INPUT;
            addActionError(getText(lEx.getMessage()));
        }

        // show menu
        openMenu(getMenuKey(false));

        choosenIndicatorVisible = chosenIndicatorId != null && getVisibility(chosenExerciseId, chosenIndicatorId);

        criterionNameMap = buildCriterionNameMap(chosenExerciseId);

        return lRes;
    }

    public SynthesisChartType getChartType() {
        return chartType;
    }

    public void setChartType(SynthesisChartType pChartType) {
        chartType = pChartType;
    }

    public Integer getChartTypeId() {
        Integer lRes = 0;
        if (chartType != null) {
            lRes = chartType.getId();
        }
        return lRes;
    }

    public void setChartTypeId(Integer pChartTypeId) {
        chartType = SynthesisChartType.parseFromId(pChartTypeId);
    }

    public boolean isDisplayCategory() {
        return chartType == SynthesisChartType.Category;
    }

    public boolean isDisplayScatter() {
        return chartType == SynthesisChartType.Scatter;
    }

    public boolean isDisplayBoxAndWhisker() {
        return chartType == SynthesisChartType.BoxAndWhisker;
    }

    public boolean isChoosenIndicatorVisible() {
        return choosenIndicatorVisible;
    }

    public void setChoosenIndicatorVisible(boolean isVisible) {
        this.choosenIndicatorVisible = isVisible;
    }

    /**
     * @return the criterion name from the translation key
     */
    public String getCriterionName(String pCriterionName) {
        return criterionNameMap.get(pCriterionName);
    }

    /**
     * do the job for box and whisker synthesis display
     *
     * @throws SispeaException
     * @throws SispeaException
     */
    protected void processBoxAndWhiskerChart(List<SliceDto> pSlices) throws SispeaException {

        // init
        List<SliceDto> lSlices = new ArrayList<>(pSlices);

        // initialization of box and whisker chart
        boxAndWhiskerChart = new BoxAndWhiskerChartBean();

        // chart params
        boxAndWhiskerChart.setTitle(buildTitleDescription());
        boxAndWhiskerChart.setWidth(BOXANDWHISKER_CHART_WIDTH);
        boxAndWhiskerChart.setHeight(BOXANDWHISKER_CHART_HEIGHT);
        boxAndWhiskerChart.setXLabel(buildCriterionDescription(true));
        boxAndWhiskerChart.setYLabel(buildIndicatorDescription(true));
        getSession().put("BOX_AND_WHISKER_CHART", boxAndWhiskerChart);

        // allowed lot status type
        List<Short> lStatusIdList = buildAllowedStatusIds();

        if (lSlices.size() < BOXANDWHISKER_CHART_SERIES_COUNT) {
            for (int i = lSlices.size() + 1; i <= BOXANDWHISKER_CHART_SERIES_COUNT; i++) {
                SliceDto lSlice = new SliceDto();
                short lId = -1;
                lSlice.setId(lId);
                String lLabel = "";
                for (int j = 0; j < i; j++) {
                    lLabel = lLabel + " ";
                }
                lSlice.setLabel(lLabel);
                lSlices.add(lSlice);
            }
        }

        // build box and whisker chart lopping on each slice
        for (SliceDto lSlice : lSlices) {
            // init slice value list
            List<Double> lSliceValues = new ArrayList<>();

            if (lSlice.getId() >= 0) {
                // get SPEA in slice :
                List<Integer> speaIds = referentialService.readBySlice(lSlice.getId(), exercise.getId());

                // build value list for box and whisker
                for (Integer lSpeaId : speaIds) {
                    // read IP value
                    IndicatorValueDto lIndicatorValue = indicatorService.findIndicatorValueByIp(indicator.getId(),
                                                                                                lSpeaId, exercise.getId(), lStatusIdList);

                    // add to slt stice data list
                    if (lIndicatorValue != null
                        && lIndicatorValue.getFloatValue() != null
                        && (!lIndicatorValue.isEmpty())
                        && lIndicatorValue.getVerification() != Verification.Anomaly) {
                        lSliceValues.add(lIndicatorValue.getFloatValue());
                    }
                }
            }

            // box and whisker chart value
            BoxAndWhiskerValueBean lChartValue = new BoxAndWhiskerValueBean(buildIndicatorDescription(false),
                                                                            lSlice.getLabel(), lSliceValues);
            boxAndWhiskerChart.add(lChartValue);
        }
    }

}
