package fr.onema.sispea.struts.search.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.util.constants.SispeaConstants;
import org.apache.log4j.Logger;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * This action is called first to initialize the territory search.
 *
 * @author CS
 */
public class ShowSearchTerritoryAction extends AbstractSearchTerritoryAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowSearchTerritoryAction.class);

    /**
     * Initialize the search form to return a certain type of results
     */
    protected Integer paramTypeResult;

    /**
     * The spea list corresponding to result territory list.
     */
    protected List<SPEADto> speaList;

    protected Map<Integer, String> speaLotStatusMap;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("show search territory");
        }

        // set the menu : if user defined -> no new menu (called from user card)
        if (!searchingForUserTerritory() && !searchingForTerritoryOrganism()) {
            openMenu(MenuConstants.MENU_KEY_SEARCH_TERRITORIES);
        }

        // no right to check

        // exercise
        checkExercise();

        // We are at initial state.
        searchTerritoryBean.setIsInitialState(true);

        // Reset all search status.
        searchTerritoryBean.resetSearchStates();

        // Check initialization parameters
        if (paramTypeResult != null) {
            searchTerritoryBean.setSimpleResultType(TerritoryType.parseFromId(paramTypeResult));
            searchTerritoryBean.setResultType(TerritoryType.parseFromId(paramTypeResult));
        }

        loadMySearchsTerritorys();

        speaList = computeSpeaList();

        Integer exerciseId;
        if (searchTerritoryBean.isExerciseSet()) {
            exerciseId = searchTerritoryBean.getExerciseId();
        } else {
            exerciseId = exercise.getId();
        }
        speaLotStatusMap = computeSpeaLotStatusMap(speaList, exerciseId);

        return SUCCESS;
    }


    public Integer getParamTypeResult() {
        return paramTypeResult;
    }

    public void setParamTypeResult(Integer pParamTypeResult) {
        paramTypeResult = pParamTypeResult;
    }

    public String getSpeaLotStatusAsString(Integer pSpeaId) {
        String lRes = "";
        if (pSpeaId != null) {
            lRes = speaLotStatusMap.get(pSpeaId);
        }
        return lRes;
    }

    /**
     * @return the spea list corresponding to result territory list
     */
    public List<SPEADto> getSPEAList() {
        return speaList;
    }

    /**
     * @return the spea list corresponding to result territory list
     */
    protected List<SPEADto> computeSpeaList() throws SispeaException {

        // init result
        List<SPEADto> pSpeas;
        Collection<TerritoryPairDto> territoryResult = null;

        // if searching for speas, get spea list
        if (displayDetailsSpea()) {
            territoryResult = searchTerritoryBean.getTerritoryResults();
        }

        // exercise
        ExerciseDto lExercise;
        if (searchTerritoryBean.getExerciseId() != null
            && (!searchTerritoryBean.getExerciseId().equals(SispeaConstants.INVALID_INT_ID))) {
            lExercise = exerciseService.readExercise(searchTerritoryBean.getExerciseId());
        } else {
            lExercise = exerciseService.getCurrentExercise();
        }

        // buildspea list
        /*if(territoryResult != null) {
            // fin corresponding spea
            for (TerritoryPair territory : territoryResult) {
                // get organism
                Organism lOrg = territoryService.getOrganismFromTerritoryId(territory.getChildTerritory().getId());
                // get corresponding spea
                SPEA lSpea = getReferentialService().readSPEA(lOrg.getId(), lExercise, false);
                // add to result
                pSpeas.add(lSpea);
            }
        }*/
        pSpeas = buildSPEAListFromTerritoryResult(territoryResult, lExercise);

        // result
        return pSpeas;
    }
}
