package fr.onema.sispea.struts.referential.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import java.io.Serializable;

/**
 * This class holds all values displayed by the drinking water network schema.
 *
 * @author CS
 */
public class DrinkingWaterNetworkSchemaBean implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * Produced volume: VP.059 (m3)
     */
    protected String production = null;

    /**
     * Distributed volume: VP.059 + VP.060 - VP.061 (m3)
     */
    protected String distribution = null;

    /**
     * Authorized consumed volume: VP.180 (m3)
     */
    protected String authorized = null;

    /**
     * Counted consumption: VP.063 + VP.201 (m3)
     */
    protected String counted = null;

    /**
     * Imported volume: VP.060 (m3)
     */
    protected String imported = null;

    /**
     * Exported volume: VP.061 (m3)
     */
    protected String exported = null;

    /**
     * Lost volume: VP.059 + VP.060 - VP.061 - VP.180 (m3)
     */
    protected String lost = null;

    /**
     * Consumed without estimate: VP.?? (m3)
     */
    protected String consumed = null;

    /**
     * Service volume: VP.?? (m3)
     */
    protected String serviceVolume = null;

    /**
     * Volume not counted: calcul (m3)
     */
    protected String notCounted = null;

    // Getters and setters

    public String getProduction() {
        return production;
    }

    public void setProduction(String pProduction) {
        production = pProduction;
    }

    public String getDistribution() {
        return distribution;
    }

    public void setDistribution(String pDistribution) {
        distribution = pDistribution;
    }

    public String getAuthorized() {
        return authorized;
    }

    public void setAuthorized(String pAuthorized) {
        authorized = pAuthorized;
    }

    public String getCounted() {
        return counted;
    }

    public void setCounted(String pCounted) {
        counted = pCounted;
    }

    public String getImported() {
        return imported;
    }

    public void setImported(String pImported) {
        imported = pImported;
    }

    public String getExported() {
        return exported;
    }

    public void setExported(String pExported) {
        exported = pExported;
    }

    public String getLost() {
        return lost;
    }

    public void setLost(String pLost) {
        lost = pLost;
    }

    public String getConsumed() {
        return consumed;
    }

    public void setConsumed(String pConsumed) {
        consumed = pConsumed;
    }

    public String getServiceVolume() {
        return serviceVolume;
    }

    public void setServiceVolume(String pServiceVolume) {
        serviceVolume = pServiceVolume;
    }

    public String getNotCounted() {
        return notCounted;
    }

    public void setNotCounted(String pNotCounted) {
        notCounted = pNotCounted;
    }

}
