package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.SispeaInputException;
import fr.onema.sispea.service.common.MessageDto;
import fr.onema.sispea.service.common.MessageType;
import fr.onema.sispea.service.data.DataDetailValueDto;
import fr.onema.sispea.service.data.SPEALotDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import fr.onema.sispea.struts.referential.bean.DataDetailType;
import fr.onema.sispea.struts.referential.bean.XmlGroupTab;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetail;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableDetailValue;
import fr.onema.sispea.struts.referential.bean.XmlGroupTableValue;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/**
 * This action show indicators of a SPEA.
 *
 * @author CS
 */
public class UpdateSpeaDataAction extends AbstractSpeaIndicatorsAction {

    private static final long serialVersionUID = 1L;

    private static final String BACK_TO_SPEA_DATA = "back";

    private static final String BACK_TO_SPEA_INDICATORS = "indicators";

    private static final String DEFAULT_NEW_BOUND_VALUE = "";

    private static final Logger logger = Logger.getLogger(UpdateSpeaDataAction.class);

    @Override
    protected String doExecute() throws Exception {
        // init result
        String lResult = SUCCESS;
        boolean isSlice = false;

        if (logger.isDebugEnabled()) {
            logger.debug("update spea data");
        }
        if (logger.isInfoEnabled()) {
            String username = "not authenticated";
            if (getCurrentUser() != null) {
                username = getCurrentUser().getCommonName() + " (" + getCurrentUser().getLogin() + ")";
            }
            logger.info("update spea data by " + username);
        }

        try {

            // check spea id
            checkSpeaParameter();

            // check exercise
            checkExerciseParameter();

            // check if spea exists
            loadSpea(exercise);

            // load users rights
            loadUserRights();

            // check edit right for result
            if ((!isHasEditRight()) && (!isHasCheckRight())) {
                openMenu(MenuConstants.MENU_KEY_SPEA_INDICATORS);
                lResult = BACK_TO_SPEA_INDICATORS;
            } else {

                //Load Lot
                loadLot();
                loadOldLot();

                // Open menu according to the current JSP item.
                openMenu(MenuConstants.MENU_KEY_SPEA_DATA);

                // editing mode
                if (logger.isInfoEnabled()) {
                    if (submitValue != null) {
                        logger.info("update spea data - Submit Value: " + submitValue);
                    } else {
                        logger.info("update spea data - Submit Value is null");
                    }
                }

                if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.editData"))) {
                    lResult = SUCCESS;
                } else if (submitValue != null && (submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndEnd"))
                                                   || submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndChange"))
                                                   || submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEdit"))
                                                   || submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndComputeRPQS")))) {

                    // Load xmlGroups from sipea session
                    List<XmlGroupTab> lXmlGroups = getSispeaSession().getXmlGroups();

                    // result messages
                    Collection<MessageDto> lMessages = new HashSet<>();

                    try {
                        // retrieve infos
                        lot = updateLotWithGroupData(lXmlGroups, lot);

                        // ****** SAVE ******
                        lMessages.addAll(speaLotService.saveSpeaLot(exercise, lot, true, getLocale().getLanguage(), getCurrentUser(), true, false, true));
                        lot.canPublish();

                    } catch (SispeaInputException lEx) {
                        // add to list
                        MessageDto lMessage = new MessageDto("", MessageType.ERROR, lEx.getMessage());
                        lMessage.setArguments(lEx.getArgs());
                        lMessages.add(lMessage);
                    }

                    // display messages
                    boolean lErrorFound = displayResultMessages(lMessages);

                    // found error ?
                    if (lErrorFound) {
                        // action result
                        lResult = Action.INPUT;
                        // show error
                        addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.notSaved"));
                        // reload xml groups from session
                        xmlGroups = getSispeaSession().getXmlGroups();
                    } else {
                        // just show message
                        addActionMessage(getText("fr.onema.sispea.referential.action.showSpeaIndicators.message.saved"));
                    }

                } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.confirmChange"))) {
                    Boolean lDelegatee = false;
                    Boolean lAddSlice = false;
                    Boolean lDeleteSlice = false;

                    if ((slicesToAddVP177 != null && slicesToAddVP177.length() > 0) || (slicesToAddVP178 != null && slicesToAddVP178.length() > 0)) {
                        lAddSlice = true;
                    }
                    if ((slicesToDeleteVP177 != null && slicesToDeleteVP177.length() > 0) || (slicesToDeleteVP178 != null && slicesToDeleteVP178.length() > 0)) {
                        lDeleteSlice = true;
                    }
                    if ((slicesToAddVP177 != null && slicesToAddVP177.length() > 0) || (slicesToDeleteVP177 != null && slicesToDeleteVP177.length() > 0)) {
                        lDelegatee = true;
                    }

                    //LoadDetailType
                    Integer lDetailTypeId;
                    if (lDelegatee) {
                        lDetailTypeId = DataDetailType.DelegateePriceDetail.getId();
                    } else {
                        lDetailTypeId = DataDetailType.CollectivityPriceDetail.getId();
                    }
                    // Load xmlGroups from sipea session
                    List<XmlGroupTab> lXmlGroups = getSispeaSession().getXmlGroups();
                    // search for group detailed
                    XmlGroupTableDetail lXmlGroupToDetail;
                    XmlGroupTableValue lXmlGroupDetailed = null;

                    for (Iterator<XmlGroupTab> iterator = lXmlGroups.iterator(); iterator.hasNext() && lXmlGroupDetailed == null; ) {
                        XmlGroupTab lXmlGroupTab = iterator.next();
                        lXmlGroupDetailed = XmlGroupTab.findTableValueContainingDetail(lDetailTypeId, lXmlGroupTab);
                    }

                    if (lXmlGroupDetailed != null) {
                        if (lAddSlice) {
                            // add slice
                            if (slicesToAddVP177 != null && slicesToAddVP177.length() > 0) {
                                // the xmlGroupTableDetail contains only one Detail if not, it's a configuration error
                                lXmlGroupToDetail = lXmlGroupDetailed.getGroupTableDetails().get(0);

                                String[] lSlicesToAddVP177str = slicesToAddVP177.replace(",", "").replace(" ", "").split(";");
                                for (String lSlice : lSlicesToAddVP177str) {
                                    try {
                                        addSlice(lXmlGroupToDetail, Long.decode(lSlice));
                                    } catch (Exception lEx) {
                                        String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.upperBound.notANumber");
                                        throw new SispeaException(lMessage);
                                    }
                                }
                            } else if (slicesToAddVP178 != null && slicesToAddVP178.length() > 0) {
                                // the xmlGroupTableDetail contains only one Detail if not, it's a configuration error
                                lXmlGroupToDetail = lXmlGroupDetailed.getGroupTableDetails().get(0);

                                String[] lSlicesToAddVP178str = slicesToAddVP178.replace(",", "").replace(" ", "").split(";");
                                for (String lSlice : lSlicesToAddVP178str) {
                                    try {
                                        addSlice(lXmlGroupToDetail, Long.decode(lSlice));
                                    } catch (Exception lEx) {
                                        String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.upperBound.notANumber");
                                        throw new SispeaException(lMessage);
                                    }
                                }
                            }
                        }
                        if (lDeleteSlice) {
                            // delete slice
                            // the xmlGroupTableDetail contains only one Detail if not, it's a configuration error
                            lXmlGroupToDetail = lXmlGroupDetailed.getGroupTableDetails().get(0);

                            // build the upper bound value list to delete;
                            List<Long> lUpperBounds = null;
                            if (slicesToDeleteVP177 != null && slicesToDeleteVP177.length() > 0) {
                                lUpperBounds = new ArrayList<>();
                                String[] lSlicesToDeleteVP177str = slicesToDeleteVP177.replace(",", "").replace(" ", "").split(";");
                                for (String lSlice : lSlicesToDeleteVP177str) {
                                    try {
                                        lUpperBounds.add(Long.decode(lSlice));
                                    } catch (Exception lEx) {
                                        String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.deleteslice.error", "", lSlice);
                                        throw new SispeaException(lMessage);
                                    }
                                }
                            } else if (slicesToDeleteVP178 != null && slicesToDeleteVP178.length() > 0) {
                                lUpperBounds = new ArrayList<>();
                                String[] lSlicesToDeleteVP178str = slicesToDeleteVP178.replace(",", "").replace(" ", "").split(";");
                                for (String lSlice : lSlicesToDeleteVP178str) {
                                    try {
                                        lUpperBounds.add(Long.decode(lSlice));
                                    } catch (Exception lEx) {
                                        String lMessage = getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.deleteslice.error", "", lSlice);
                                        throw new SispeaException(lMessage);
                                    }
                                }
                            }

                            // delete
                            deleteSlice(lXmlGroupToDetail, lUpperBounds);
                        }

                        // Convert XmlGroup as SpeaLot
                        lot = updateLotWithGroupData(lXmlGroups, lot);

                        // Recompute VPs
                        speaLotService.recomputeVPs(lot);

                        // Reconvert SpeaLot as XmlGroup
                        lXmlGroups = buildXmlBean(lot, oldLot, spea.getCompetence().getId(), isHasViewRight());

                        // store in session
                        getSispeaSession().setXmlGroups(lXmlGroups);
                    }

                    //update isSlice to stay in the update way
                    isSlice = true;
                } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.cancelEdit"))) {
                    // don't edit
                    editingGroupId = null;

                } else if ((submitValue != null)
                           && (submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.cancel"))
                               || submitValue.equals(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.button.save")))) {
                    // canceling price edition -> stay editing
                    xmlGroups = getSispeaSession().getXmlGroups();
                    lResult = BACK_TO_SPEA_DATA;
                } else if ((submitValue != null)
                           && (submitValue.equals(getText("fr.onema.sispea.referential.datagroup.general.submit.commentEdit")))) {

                    // just show message
                    addActionMessage(getText("fr.onema.sispea.referential.action.showSpeaIndicators.message.saved"));
                }
            }

            // remove groups from session
            if (Action.SUCCESS.equals(lResult) && submitValue != null && (
                    submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndEnd"))
                    || submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndComputeRPQS")))) {
                if (!isSlice) {
                    getSispeaSession().setXmlGroups(null);
                }
            }


            // Generate RPQS?
            if (Action.SUCCESS.equals(lResult) && submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndComputeRPQS"))) {
                if (!isSlice) {
                    // Generate the RPQS
                    generateRpqs(getCurrentUser(), spea, exercise);
                }
            }


        } catch (SispeaException lEx) {
            lResult = Action.INPUT;
            String lMessage = getText(lEx.getMessage());
            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.common", "", lMessage));
        }

        // if succes -> display db infos
        if ((Action.SUCCESS.equals(lResult) || BACK_TO_SPEA_INDICATORS.equals(lResult))) {
            if (!isSlice) {
                if (submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.editData")) || submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndChange"))) {
                    // check parameters and load data
                    manageViewActions(false, false, true);
                    if (groupToEditId == null && (editingGroupId == null || editingGroupId.length() == 0)) {

                        for (Iterator<XmlGroupTab> iterator = xmlGroups.iterator(); iterator.hasNext() && groupToEditId == null; ) {
                            XmlGroupTab myGroupTab = iterator.next();
                            if (!myGroupTab.isGeneralTab()) {
                                groupToEditId = myGroupTab.getId();
                            }
                        }
                        editingGroupId = groupToEditId;
                    } else if (groupToEditId == null) {
                        // when cliking on enter -> arriving here : not an error
                        if (!submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEditAndChange"))) {
                            addActionError(getText("fr.onema.sispea.referential.action.showSpeaIndicators.error.groupIdNotChose"));
                        }
                        groupToEditId = editingGroupId;
                    } else {
                        editingGroupId = groupToEditId;
                    }

                } else if (submitValue.equals(getText("fr.onema.sispea.jsp.fixRef.showSPEAData.saveEdit"))) {
                    // check parameters and load data
                    manageViewActions(false, false, true);
                    groupToEditId = editingGroupId;
                } else {
                    // check parameters and load data
                    manageViewActions(false, false, true);
                    // stay en same tab if modifing once agin
                    groupToEditId = editingGroupId;
                    // don't edit
                    editingGroupId = null;
                }
            } else {
                // check parameters and load data from session
                manageViewActions(false, true, true);

            }
        }

        // result
        return lResult;
    }

    /**
     * add new slice
     *
     * @param pXmlGroupTableDetail
     * @param pUpperBound
     * @throws SispeaException
     */
    protected void addSlice(XmlGroupTableDetail pXmlGroupTableDetail, Long pUpperBound) throws SispeaException {

        // sort dataDetailValue by upper bound
        List<Long> lUpperBoundList = getUpperBoundList(pXmlGroupTableDetail);

        // sort dataDetailValue by lower bound
        List<Long> lLowerBoundList = getLowerBoundList(pXmlGroupTableDetail);

        // check if bound already exists
        if (lUpperBoundList.contains(pUpperBound)) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundAlreadyExists"));
        } else if (lLowerBoundList.contains(pUpperBound)) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundAlreadyExists"));
        } else if (pUpperBound.intValue() > DataDetailValueDto.DEFAULT_UPPER_BOUND) {
            addActionError(getText("fr.onema.sispea.dataDetail.jsp.showPriceEditor.error.addSlice.boundTohigh"));
        } else {

            // when adding a slice : always adding a slice between an other existing, cuting this existing slice
            // in two : lower part saty the same, higher part take 0.

            // find a slice to copy
            XmlGroupTableDetailValue lNewSliceValue = null;
            XmlGroupTableDetailValue lClonedSliceValue = null;
            for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
                if (lXmlGroupTableDetailValue.isSliceValue()) {
                    if (lNewSliceValue == null) {
                        lNewSliceValue = lXmlGroupTableDetailValue.clone();
                        lClonedSliceValue = lXmlGroupTableDetailValue;
                    } else {
                        // check if upper bound is < then new value upper bound bound
                        DataDetailValueDto lTestValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();
                        if (lTestValue != null && lTestValue.getLowerBound().intValue() < pUpperBound.intValue()) {
                            lNewSliceValue = lXmlGroupTableDetailValue.clone();
                            lClonedSliceValue = lXmlGroupTableDetailValue;
                        }
                    }
                }
            }

            // set Id
            lNewSliceValue.setId(passwordService.generateNewPassword());

            // change DataDetailValue
            DataDetailValueDto lOldValue = (DataDetailValueDto) lNewSliceValue.getValue();
            DataDetailValueDto lDataDetailValue = new DataDetailValueDto(lOldValue.getDataDetail(), lOldValue.getUpperBound(), lOldValue.getLowerBound(), lOldValue.getFloatValue());
            lNewSliceValue.setValue(lDataDetailValue);

            // remove comment
            lNewSliceValue.setComment(null);

            // Get min bound
            lowerBound = getMinBound(lUpperBoundList, pUpperBound);

            // create dataDetailValue
            DataDetailValueDto lDetailValue = (DataDetailValueDto) lNewSliceValue.getValue();
            lDetailValue.setUpperBound(pUpperBound);
            lDetailValue.setLowerBound(lowerBound);

            // the create value gets the cloned value value
            // the cloned value gets the DEFAULT_NEW_BOUND_VALUE
            lDetailValue.setFormattedFloatValue(((DataDetailValueDto) lClonedSliceValue.getValue()).getFormattedFloatValue());
            lClonedSliceValue.getValue().setFormattedFloatValue(DEFAULT_NEW_BOUND_VALUE);

            //add the new slice xml display group
            pXmlGroupTableDetail.add(lNewSliceValue);

            // refresh bounds
            refreshBounds(pXmlGroupTableDetail);
        }
    }

    /**
     * Delete the slices with upperbound values inlist
     *
     * @param pXmlGroupTableDetail
     * @param pUpperBoundValues
     * @throws SispeaException
     */
    protected void deleteSlice(XmlGroupTableDetail pXmlGroupTableDetail, List<Long> pUpperBoundValues) throws SispeaException {

        // loop on upper bounds
        for (Iterator<XmlGroupTableDetailValue> iterator = pXmlGroupTableDetail.getGroupTableDetailValues().iterator(); iterator.hasNext(); ) {
            XmlGroupTableDetailValue lXmlGroupTableDetailValue = iterator.next();
            if (lXmlGroupTableDetailValue.isSliceValue()) {
                DataDetailValueDto lValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                // check if upper bound is in list
                if (lValue.getUpperBound() != null) {
                    if ((!lValue.getUpperBound().equals(getMaxSliceUpperBound()))
                        && pUpperBoundValues.contains(lValue.getUpperBound())) {
                        iterator.remove();
                    }
                }
            }
        }

        // refresh bounds
        refreshBounds(pXmlGroupTableDetail);
    }


    /**
     * refresh upper and lower bound value
     *
     * @param pXmlGroupTableDetail
     */
    protected void refreshBounds(XmlGroupTableDetail pXmlGroupTableDetail) {

        // sort slices
        Collections.sort(pXmlGroupTableDetail.getGroupTableDetailValues());

        // loop
        Long lLowerBound = (long) 0;
        for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
            // slice ?
            if (lXmlGroupTableDetailValue.isSliceValue()) {
                DataDetailValueDto lValue = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                // update bounds
                lValue.setLowerBound(lLowerBound);
                lLowerBound = lValue.getUpperBound();

                // update name
                lXmlGroupTableDetailValue.setName(getText("fr.onema.sispea.dataDetail.collectivity.slice.read",
                                                          "", new String[]{lValue.getLowerBound().toString(), lValue.getUpperBound().toString()}));
            }
        }
    }

    /**
     * @param pXmlGroupTableDetail
     * @param pUperBounds
     * @return a list of bound (upper or lower)
     */
    protected List<Long> getBoundList(XmlGroupTableDetail pXmlGroupTableDetail, Boolean pUperBounds) {
        // init
        List<Long> lRes = new ArrayList<>();

        if (pXmlGroupTableDetail != null) {

            // get bound
            for (XmlGroupTableDetailValue lXmlGroupTableDetailValue : pXmlGroupTableDetail.getGroupTableDetailValues()) {
                if (lXmlGroupTableDetailValue.isSliceValue()) {


                    // get the upperBound Value
                    DataDetailValueDto lVal = (DataDetailValueDto) lXmlGroupTableDetailValue.getValue();

                    if (pUperBounds) {
                        // add upperBound to the list
                        lRes.add(lVal.getUpperBound());
                    } else {
                        // add lowerBound to the list
                        lRes.add(lVal.getLowerBound());
                    }
                }
            }
        }
        //result
        return lRes;
    }

    /**
     * @param upperBoundList
     * @return min bound from upperBound list
     */
    protected Long getMinBound(List<Long> upperBoundList, Long pCurrentUpperBound) {
        // init
        Long lRes = (long) 0;

        for (Long lBound : upperBoundList) {
            if (pCurrentUpperBound > lBound && lBound > lRes) {
                // set the min bound value
                lRes = lBound;
            }
        }

        //result
        return lRes;
    }

    /**
     * @param pXmlGroupTableDetail
     * @return the list of bounds from xmlDisplayGroup in sispea session
     */
    protected List<Long> getUpperBoundList(XmlGroupTableDetail pXmlGroupTableDetail) {
        return getBoundList(pXmlGroupTableDetail, true);
    }

    /**
     * @param pXmlGroupTableDetail
     * @return the list of bounds from xmlDisplayGroup in sispea session
     */
    protected List<Long> getLowerBoundList(XmlGroupTableDetail pXmlGroupTableDetail) {
        return getBoundList(pXmlGroupTableDetail, false);
    }

    public List<XmlGroupTab> getXmlDisplayGroups() {
        return getSispeaSession().getXmlGroups();
    }

    public void setXmlDisplayGroups(List<XmlGroupTab> pXmlGroups) {
        getSispeaSession().setXmlGroups(pXmlGroups);
    }

    /**
     * update lot with group data
     *
     * @param pXmlGroupTabs
     * @param pLot
     * @throws SispeaException
     */
    protected SPEALotDto updateLotWithGroupData(List<XmlGroupTab> pXmlGroupTabs, SPEALotDto pLot) throws SispeaException, SispeaInputException {

        // init
        SPEALotDto lRes = pLot;

        // loop on tabs to update tab
        for (XmlGroupTab lXmlGroupTab : pXmlGroupTabs) {
            // update lot
            if (lXmlGroupTab.getId().equals(editingGroupId)) {
                lRes = XmlGroupTab.updateLotWithGroupData(lXmlGroupTab, lRes);
            }
        }

        // result
        return lRes;

    }
}
