package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.referential.MunicipalityDto;

/**
 * This action display a municipality.
 *
 * @author CS
 */
public class ShowMunicipalityFrAction extends ShowMunicipalityAction {

    private static final long serialVersionUID = 1L;

    /**
     * year to get the exercise from
     */
    protected String annee;

    /**
     * insee code of the municipality to get the Id from
     */
    protected String insee;

    @Override
    protected void checkInputParameters() throws SispeaException {

        checkInsee();
        checkYear();

    }

    /**
     * Check the INSEE parameter. If not set, throws an error
     */
    protected void checkInsee() throws SispeaException {

        if (insee == null || "".equals(insee)) {
            id = null;
        } else {
            // Retrieve ID from INSEE code
            MunicipalityDto m = referentialService.findMunicipalityByInseeCode(insee);
            if (m == null) {
                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showMunicipality.error.invalidMunicipalityInsee"));
            }
            id = m.getId().toString();
        }

        checkId();
    }


    /**
     * Check the Year parameter. If not set, set to current exercise.
     */
    protected void checkYear() throws SispeaException {

        if (annee == null || "".equals(annee)) {
            exercise = exerciseService.getCurrentExercise();
        } else {

            Short lYear;
            try {
                lYear = Short.valueOf(annee);
            } catch (NumberFormatException e) {
                throw new SispeaException(getText("fr.onema.sispea.jsp.fixRef.showMunicipality.error.invalidYear", "", annee));
            }
            exercise = exerciseService.getExerciseByYear(lYear);

            if (exercise == null) {
                addActionMessage(getText("fr.onema.sispea.jsp.fixRef.showMunicipality.error.wrongYear", "", annee));
                exercise = exerciseService.getCurrentExercise();
            }

        }

        chosenExerciseId = exercise.getId();
        annee = exercise.getStrYear();
    }

    public String getAnnee() {
        return annee;
    }

    public void setAnnee(String pAnnee) {
        annee = pAnnee;
    }

    public String getInsee() {
        return insee;
    }

    public void setInsee(String pInsee) {
        insee = pInsee;
    }

}
