package fr.onema.sispea.struts.referential.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.common.PagingDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.referential.CollectivityDto;
import fr.onema.sispea.service.referential.MunicipalityDto;
import fr.onema.sispea.service.referential.OrganismDto;
import fr.onema.sispea.service.referential.OrganismType;
import fr.onema.sispea.service.referential.SPEADto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.referential.TerritoryPairDto;
import fr.onema.sispea.service.referential.TerritoryType;
import fr.onema.sispea.service.search.OrderByFieldDto;
import fr.onema.sispea.service.search.OrderByFieldType;
import fr.onema.sispea.service.search.SearchFieldsDto;
import fr.onema.sispea.service.search.SearchTerritoryResultDto;
import fr.onema.sispea.service.search.UserOrderByFieldPossibility;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.util.constants.SispeaConstants;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This action handles the territory related actions.
 *
 * @author CS
 */
public abstract class AbstractTerritoryAction extends AbstractReferentialCardAction {

    /**
     * Internationalization prefix for territory presentation GUI.
     */
    protected static final String TERRITORY_PREFIX = "fr.onema.sispea.jsp.fixRef.showTerritory.";

    protected static final Integer DISPLAY_MODE_SOME_TERRITORY = 0;

    protected static final Integer DISPLAY_MODE_MY_TERRITORY = 1;

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractTerritoryAction.class);

    /**
     * The paging information for territory organisms.
     */
    protected PagingDto pagingOrganism = new PagingDto();

    /**
     * The paging information for territory speas.
     */
    protected PagingDto pagingSpeas = new PagingDto();

    /**
     * Flag to know if territory name modification panel is visible.
     */
    protected boolean modifName;

    /**
     * Flag to know if territory organisms modification panel is visible.
     */
    protected boolean modifOrganisms;

    /**
     * Territory name currently modified.
     */
    protected String territoryName;

    /**
     * List of organisms to remove from this territory in edition mode.
     */
    protected List<String> organismsToRemove = new ArrayList<>();

    /**
     * display mode
     */
    protected Integer mode = 0;

    /**
     * the list of spea included in territory
     */
    protected List<SPEADto> speas;

    /**
     * Territory associated to current organism displayed.
     */
    protected TerritoryDto territory;

//    /**
//     * update date for ddt
//     */
//    private Date updateDate;

//    /**
//     * update date already loaded ?
//     */
//    private Boolean updateDateLoaded = false;

    /**
     * ID of the displayed territory.
     */
    private Integer territoryId;

    /**
     * check parameters ands loads territory
     *
     * @throws SispeaException
     */
    public void checkTerritory() throws SispeaException {

        // check mode
        if (mode != null && mode.equals(DISPLAY_MODE_MY_TERRITORY)) {
            // displaying my territory -> get user's territory
            if (getCurrentUserTerritory() != null) {
                territoryId = getCurrentUserTerritory().getId();
            }
        } else {
            mode = DISPLAY_MODE_SOME_TERRITORY;
        }

        // check the territory to display.
        if (territoryId == null) {
            throw new SispeaException(getText(TERRITORY_PREFIX + "error.noTerritoryId"));
        }

        // read territory
        territory = territoryService.readTerritory(territoryId);

        // check territory loaded
        if (territory == null) {
            throw new SispeaException(getText(TERRITORY_PREFIX + "error.noTerritory", "", territoryId.toString()));
        }
    }

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug(getText("fr.onema.sispea.struts.referential.action.TerritoryAction.debug.doExecute"));
//        }
//
//        // nothing
//
//        // result
//        return SUCCESS;
//
//    }

//    /**
//     * @return
//     * @throws SispeaException
//     */
//    public Date getDdtRefUpdate() throws SispeaException {
//
//        // init
//        Date lRes = null;
//
//        // read ddt from territory id
//        DDTDto lDdt = referentialService.readDDTFromTerritoryId(territoryId, exercise);
//
//        // loop on ddt updates to find
//        for (DdtRefUpdateDto lDdtRefUpdate : lDdt.getDdtUpdates()) {
//            if (lDdtRefUpdate != null && lDdtRefUpdate.getExercise().getId().equals(exercise.getId())) {
//                lRes = lDdtRefUpdate.getDateUpdate();
//            }
//        }
//
//        // search for update date for exercise
//        return lRes;
//    }

    /**
     * getter called by struts, should return SPEA org id
     *
     * @return
     */
    public Integer getSpeaId() {
        Integer lRes = -1;

        // check territory
        if ((territory != null) && (territory.getType() == TerritoryType.SPEA) && (territory.getOrganisms().size() == 1)) {
            lRes = ((SPEADto) territory.getOrganisms().toArray()[0]).getId();
        }

        // result
        return lRes;
    }

    /**
     * getter called by struts, should return collectivity org id
     *
     * @return
     */
    public Integer getCollectivityId() {
        Integer lRes = -1;

        // check territory
        if ((territory != null) && (territory.getType() == TerritoryType.Collectivity) && (territory.getOrganisms().size() == 1)) {
            lRes = ((CollectivityDto) territory.getOrganisms().toArray()[0]).getId();
        }

        // result
        return lRes;
    }

    /**
     * getter called by struts, should return municipality org id
     *
     * @return
     */
    public Integer getMunicipalityId() {
        Integer lRes = -1;

        // check territory
        if ((territory != null) && (territory.getType() == TerritoryType.Municipality) && (territory.getOrganisms().size() == 1)) {
            lRes = ((MunicipalityDto) territory.getOrganisms().toArray()[0]).getId();
        }

        // result
        return lRes;
    }

    /**
     * Get Map of search types.
     *
     * @return Map of search types.
     */
    public Map<String, String> getSearchTypes() {
        Map<String, String> result = new HashMap<>();

        // add territory types
        for (TerritoryType type : TerritoryType.values()) {
            if (type.getSearchable()) {
                result.put(type.name(), getText(type.getLabelKey()));
            }
        }

        return result;
    }

    /**
     * Get Map of result types.
     *
     * @return Map of result types.
     */
    public Map<String, String> getResultTypes() {

        // result map
        Map<String, String> lRes = new HashMap<>();

        // add territory types for common search
        for (TerritoryType type : TerritoryType.values()) {
            if (type.getResultable()) {
                lRes.put(type.name(), getText(type.getLabelKey()));
            }
        }

        // result
        return lRes;
    }

//    /**
//     * return true if current user can view user's details
//     *
//     * @return
//     * @throws SispeaException
//     */
//    public Boolean canViewUserDetails() throws SispeaException {
//        // Use a null variable to force Java to chose the right method
//        TerritoryDto territory = null;
//        return checkUserRight(Right.EditUser, territory, exercise);
//    }

//    /**
//     * Test if currently displayed territory can be edited by current user.
//     * User must be an administrator and the territory must be of type 'mixed'.
//     *
//     * @return
//     */
//    public Boolean canEditTerritory() {
//        TerritoryDto lTerritory = territory;
//
//        // If a territory exists and is a Mixed territory, it can be edited.
//        boolean lMixedTerritory = (lTerritory != null) && (TerritoryType.Mixed.equals(lTerritory.getType()));
//        // If user is an administrator, he can edit a territory.
//        boolean lAdminUser = getSispeaSession().getUser().checkRight(Right.Manage);
//
//        return lMixedTerritory && lAdminUser;
//    }

    /**
     * manage territory organisms paging after Territory loading.
     */
    protected void manageOrganismPaging() {

        int lCount = territory.getOrganisms().size();

        // set member result count
        pagingOrganism.setResultCount(lCount);

        // get start and end idx to extract
        Integer lStartIdx = pagingOrganism.getStartIndex() * pagingOrganism.getPageSize();
        Integer lEndIdx = lStartIdx + pagingOrganism.getPageSize();
        if (lEndIdx >= lCount) {
            lEndIdx = lCount;
        }

        ArrayList<OrganismDto> lOrganisms = (ArrayList<OrganismDto>) territory.getSortedOrganisms();

        // make sub list
        List<OrganismDto> lSubList = lOrganisms.subList(lStartIdx, lEndIdx);

        // set sub list
        territory.setOrganisms(lSubList);

        // set page offset
        pagingOrganism.setPageOffset(pagingOrganism.getStartIndex());
    }

    /**
     * Load users of a territory.
     *
     * @throws SispeaException
     */
    protected void loadTerritoryUsers(TerritoryDto pTerritory) throws SispeaException {
        // sort order
        SearchFieldsDto lFilter = new SearchFieldsDto();
        lFilter.getOrderByFields().add(new OrderByFieldDto(OrderByFieldType.ASC, UserOrderByFieldPossibility.defaut.getTableAlias(),
                                                           UserOrderByFieldPossibility.defaut.getHqlFieldName(), UserOrderByFieldPossibility.defaut.getSqlFieldName()));

        // Load all users associated to this territory.
        List<UserDto> lUsers = userService.readUsers(pTerritory, false, false, 0, SispeaConstants.RETURN_ALL_RESULTS, lFilter);

        pTerritory.setUsers(lUsers);
    }

    /**
     * load speas territories
     *
     * @param territory
     * @param exercise
     * @throws SispeaException
     */
    protected void loadTerritorySpeas(TerritoryDto territory, ExerciseDto exercise) throws SispeaException {

        // count speas if first page
        if (pagingSpeas.getGoToPage() == PagingDto.FIRST_PAGE) {
            // get count
//            int resultCount = territoryService.countTerritories(territory.getId(), territory.getType(),
//                    null, null, TerritoryType.SPEA, pExercise.getId(), null);
            List<SearchTerritoryResultDto> lResult = territoryService.searchIncludedTerritories(territory,
                                                                                                OrganismType.SPEA,
                                                                                                exercise,
                                                                                                pagingSpeas.getStartIndex() * pagingSpeas.getPageSize(),
                                                                                                SispeaConstants.RETURN_ALL_RESULTS,
                                                                                                true);
            int resultCount = 0;
            for (SearchTerritoryResultDto lSearchTerritoryResult : lResult) {
                if (lSearchTerritoryResult != null && lSearchTerritoryResult.getCount() != null) {
                    resultCount = resultCount + lSearchTerritoryResult.getCount();
                }
            }

            // set to results
            pagingSpeas.setResultCount(resultCount);

            // log it
            if (logger.isDebugEnabled()) {
                logger.debug(resultCount + " speas(s) found");
            }
        }

        // init spea list
        speas = new ArrayList<>();

        // search for speas if not super virtual
        List<SearchTerritoryResultDto> lResult = territoryService.searchIncludedTerritories(territory,
                                                                                            OrganismType.SPEA,
                                                                                            exercise,
                                                                                            pagingSpeas.getStartIndex() * pagingSpeas.getPageSize(),
                                                                                            pagingSpeas.getPageSize(), false);
        Collection<TerritoryPairDto> lPairs = SearchTerritoryResultDto.getPairs(lResult);

        // loop
        speas = new ArrayList<>();
        for (TerritoryPairDto lPair : lPairs) {
            // store
            if ((lPair != null) && (lPair.getChildTerritoryId() != null)) {
                // load organism
                OrganismDto lOrg = territoryService.getOrganismFromTerritoryId(lPair.getChildTerritoryId());
                // get corresponding spea
                SPEADto lSpea = referentialService.readSPEA(lOrg.getId(), exercise, false);
                // add to result
                speas.add(lSpea);
            }
        }
//        }

        // page offset
        pagingSpeas.setPageOffset(pagingSpeas.getStartIndex());
    }

    //FIXME Vor si on en a encore besoin ?
//    @Override
//    protected TerritoryDto loadTerritory() throws SispeaException {
//        return getSispeaSession().getTerritory();
//    }

    public boolean isModifName() {
        return modifName;
    }

    public void setModifName(boolean pModifName) {
        modifName = pModifName;
    }

    public String getTerritoryName() {
        return territoryName;
    }

    public void setTerritoryName(String pTerritoryName) {
        territoryName = pTerritoryName;
    }

    public boolean isModifOrganisms() {
        return modifOrganisms;
    }

    public void setModifOrganisms(boolean pModifOrganisms) {
        modifOrganisms = pModifOrganisms;
    }

    public List<String> getOrganismsToRemove() {
        return organismsToRemove;
    }

    public void setOrganismsToRemove(List<String> pOrganismsToRemove) {
        organismsToRemove = pOrganismsToRemove;
    }

    public PagingDto getPagingOrganism() {
        return pagingOrganism;
    }

    public Integer getMode() {
        return mode;
    }

    public void setMode(Integer pMode) {
        mode = pMode;
    }

    public PagingDto getPagingSpeas() {
        return pagingSpeas;
    }

    public List<SPEADto> getSpeas() {
        return speas;
    }

    public void setSpeas(List<SPEADto> pSpeas) {
        speas = pSpeas;
    }

    public Integer getTerritoryId() {
        return territoryId;
    }

    public void setTerritoryId(Integer pTerritoryId) {
        territoryId = pTerritoryId;
    }

//    public Date getUpdateDate() throws SispeaException {
//        if (!updateDateLoaded) {
//            updateDate = getDdtRefUpdate();
//            updateDateLoaded = true;
//        }
//        return updateDate;
//    }
//
//    public void setUpdateDate(Date pUpdateDate) {
//        updateDate = pUpdateDate;
//    }

    public TerritoryDto getTerritory() {
        return territory;
    }

    public void setTerritory(TerritoryDto territory) {
        this.territory = territory;
    }
}
