package fr.onema.sispea.struts.exchange.bean;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import java.io.Serializable;

/**
 * This class holds an available pre-generated export.
 *
 * @author CS
 */
public class AvailableDownload implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * The database id of the export.
     */
    private int id = 0;

    /**
     * The export title.
     */
    private String title = null;

    /**
     * The export generation date.
     */
    private String date = null;

    /**
     * Default constructor.
     */
    public AvailableDownload(int pId, String pTitle, String pDate) {
        id = pId;
        title = pTitle;
        date = pDate;
    }

    /**
     * Returns the title of the export to use in the GUI.
     *
     * @return The title.
     */
    public String getTitle() {
        return title;
    }

    public String getDate() {
        return date;
    }

    public int getId() {
        return id;
    }

}
