package fr.onema.sispea.struts.exchange.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.OriginType;
import fr.onema.sispea.service.data.SPEALotStatus;
import fr.onema.sispea.service.exchange.FileExchangeService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Map;
import java.util.TreeMap;

/**
 * This class is the super class of all file uploading actions.
 * It allows the end user to upload data and referential.
 *
 * @author CS
 */
public abstract class AbstractFileUploadAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient FileExchangeService fileExchangeService;

    /**
     * Flag if true, do a regular import
     */
    protected Boolean standardImport = Boolean.TRUE;

//    /**
//     * the status list
//     */
//    protected Map<String, String> statusList;

    /**
     * the selected status, if NULL any status
     */
    protected Integer statusId = 0;

//    /**
//     * the origin type list the admin can choose from
//     */
//    protected Map<String, String> originTypesList;

    /**
     * the selected origin type
     */
    protected Integer originTypeId = 0;

    /**
     * Flag if true, overwrite previous data
     */
    protected Boolean overwriteData = Boolean.FALSE;

    /**
     * Flag if true, do not overwrite speas in status
     */
    protected Boolean preserveStatus = Boolean.TRUE;

    /**
     * An optionnal comment the general admin can add when uploading an XML file
     */
    protected String comment;

    /**
     * This method should throw an exception if the user has not got the right to access the function.
     *
     * @throws SispeaException
     */
    @Override
    protected void checkRight() throws SispeaException {

        UserDto lUser = getCurrentUser();

        // mandatable user's allowed
        if (lUser != null && lUser.getMandatable()) {
            // allowed
        } else {
            // check rights : current user must have editRef or edit
            if ((!checkUserRight(Right.Manage))
                && (!checkUserRight(Right.EditRef))
                && (!checkUserRight(Right.Edit))) {
                // redirect to error
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }
            // else : nothing -> admin allowed
        }
    }

    public Boolean getStandardImport() {
        return standardImport;
    }

    public void setStandardImport(Boolean pStandardImport) {
        standardImport = pStandardImport;
    }

    public Map<String, String> getStatusList() {
        //init list
        TreeMap<String, String> lRes = new TreeMap<>();

        lRes.put("", getText("fr.onema.sispea.exchange.upload.file.options.status.all"));
        for (SPEALotStatus lStatus : SPEALotStatus.values()) {
            lRes.put(lStatus.getId().toString(), getText(lStatus.getLabelKey()));
        }

        return lRes;
    }

    public Integer getStatusId() {
        return statusId;
    }

    public void setStatusId(Integer pStatusId) {
        statusId = pStatusId;
    }

    public Map<String, String> getOriginTypesList() {
        //init list
        TreeMap<String, String> lRes = new TreeMap<>();

        for (OriginType lOriginType : OriginType.values()) {
            if (lOriginType.isAdminImport()) {
                lRes.put(lOriginType.getId().toString(), getText(lOriginType.getLabelKey()));
            }
        }

        return lRes;
    }

    public Integer getOriginTypeId() {
        return originTypeId;
    }

    public void setOriginTypeId(Integer pOriginTypeId) {
        originTypeId = pOriginTypeId;
    }

    public Boolean getOverwriteData() {
        return overwriteData;
    }

    public void setOverwriteData(Boolean pOverwriteData) {
        overwriteData = pOverwriteData;
    }

    public Boolean getPreserveStatus() {
        return preserveStatus;
    }

    public void setPreserveStatus(Boolean pPreserveStatus) {
        preserveStatus = pPreserveStatus;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String pComment) {
        comment = pComment;
    }

}
