package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the user password change.
 * It test the ccrypted login and reinit associated password.
 *
 * @author CS
 */
public class ReinitForgottenPasswordAction extends AbstractForgottenPasswordAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ReinitForgottenPasswordAction.class);

    /**
     * crypted login
     */
    protected Integer key;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("reinitForgottenPassword - doExecute");
        }

        // menu
        openMenu(MenuConstants.MENU_KEY_CONNECTION);

        // check key
        String lLogin = userService.getDecryptedLogin(key);

        if (lLogin == null) {
            addActionError(getText("fr.onema.sispea.common.reinitForgottenPassword.error.badCrypted"));
        } else {

            UserDto lUser = userService.readUser(lLogin);
            if (lUser == null) {
                addActionError(getText("fr.onema.sispea.common.reinitForgottenPassword.error.unknownLogin"));
            } else {
                // reinit password
                userService.reinitPwdUser(lUser, getLocale().getLanguage(), null, false, false);
                // success
                addActionMessage(getText("fr.onema.sispea.common.reinitForgottenPassword.success"));
            }
        }

        // result
        return SUCCESS;
    }

    // getters and setters

    public Integer getKey() {
        return key;
    }

    public void setKey(Integer pKey) {
        key = pKey;
    }

}
