package fr.onema.sispea.struts.common.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;

import javax.servlet.http.HttpServletRequest;

/**
 * This action deconnects the user.
 *
 * @author CS
 */
public class LogoutAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(LogoutAction.class);

    @Override
    protected String doExecute() throws Exception {

        removeSession();

        // Invalidate the session
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request.getSession() != null) {
            request.getSession().invalidate();
        }

        if (logger.isDebugEnabled()) {
            logger.debug("User logged out");
        }

        return SUCCESS;
    }

    @Override
    public void buildMenu() {
        // nothing to do -> just to avoid menu building after session terminate
    }
}
