package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.DataListColorType;
import fr.onema.sispea.service.data.DataListDto;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.VPDto;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.TerritoryDto;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.List;

public class UpdateDataListsAction extends AbstractDataListsAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractDataListsAction.class);

    @Override
    protected String doExecute() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("update Data lists");
        }

        // init result
        String lResult = Action.SUCCESS;

        // set the menu
        openMenu(MenuConstants.MENU_KEY_DATALISTS);

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        try {

            checkUsersSelections();

            if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.admin.dataLists.buttons.cancel"))) {
                // Cancel: return to lists
                selectedListId = null;
                currentList = null;
                fromExerciseId = null;
                toExerciseId = null;
                competenceId = null;

            } else if (submitValue != null && submitValue.equals(getText("fr.onema.sispea.jsp.admin.dataLists.buttons.save"))) {

                DataListDto lDataList;
                if (selectedListId != null) {
                    // Update list: get the datalist from DB
                    lDataList = indicatorService.readDataList(selectedListId);
                    Preconditions.checkState(lDataList.getId() != null, "L'id de la dataList doit être renseigné");
                    Preconditions.checkState(lDataList.getId().equals(selectedListId), "L'id de la dataList doit être celui qui a été demandé!");
//                    lDataList.setId(selectedListId);
                } else {
                    // New list
                    lDataList = new DataListDto();
                }

                if (StringUtils.isBlank(currentList.getName())) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.noName"));
                }
                if (StringUtils.isBlank(currentList.getLegend())) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.noLegend"));
                }
                lDataList.setName(currentList.getName());
                lDataList.setLegend(currentList.getLegend());

                if (StringUtils.isBlank(indicators)) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.noIndicator"));
                }

                String[] lArrIndicators = indicators.split(";");
                List<IndicatorDto> lIps = new ArrayList<>();
                List<VPDto> lPvs = new ArrayList<>();

                // Get all IPs
                List<IndicatorDto> lDbIps = indicatorService.readIndicators(null, null);
                // Get all Vps
                List<VPDto> lDbPvs = new ArrayList<>(indicatorService.readPVs());
                // Add all vps displayed as dc (see https://forge.eaufrance.fr/issues/6613)
                lDbPvs.addAll(indicatorService.readVpDisplayedAsDcs());

                // Map codes to indicators
                for (String lArrIndicator : lArrIndicators) {
                    // search if it's an IP
                    IndicatorDto tInd = getIndicatorByCode(lDbIps, lArrIndicator);
                    if (tInd != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Get IP: " + lArrIndicator);
                        }
                        lIps.add(tInd);
                    } else {

                        // IP not found, search if it's an VP
                        VPDto tPv = getPvByCode(lDbPvs, lArrIndicator);
                        if (tPv != null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug("Get VP: " + lArrIndicator);
                            }
                            lPvs.add(tPv);
                        } else {

                            // Not an IP, nor an VP, error
                            if (logger.isDebugEnabled()) {
                                logger.debug("Not found as an IP nor a VP: " + lArrIndicator);
                            }
                            String lMessage = getText("fr.onema.sispea.jsp.admin.dataLists.error.wrongIndicatorCode", "", lArrIndicator);
                            logger.error(lMessage);
                            addActionError(lMessage);
                        }
                    }
                }
                lDataList.setIps(lIps);
                lDataList.setVps(lPvs);

                //territory
                if (territoryId == null) {
                    throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.noTerritory"));
                }
                TerritoryDto lTerritory = territoryService.readTerritory(territoryId);
                lDataList.setTerritory(lTerritory);

                ExerciseDto fromExercise = null;
                if (fromExerciseId != null) {
                    fromExercise = exerciseService.readExercise(fromExerciseId);
                    if (fromExercise == null) {
                        throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.wrongYear", "L'année n'est pas en base ! ", fromExerciseId.toString()));
                    }
                }

                ExerciseDto toExercise = null;
                if (toExerciseId != null) {
                    toExercise = exerciseService.readExercise(toExerciseId);
                    if (toExercise == null) {
                        throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.wrongYear", "L'année n'est pas en base ! ", toExerciseId.toString()));
                    }

                    if (fromExercise != null) {

                        // From Exercise <= To Exercise
                        Short fromYear = fromExercise.getYear();
                        if (fromYear > toExercise.getYear()) {
                            throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.fromExerciseAfterToExercise"));
                        }
                    }
                }

                CompetenceDto competence = null;
                if (competenceId != null) {

                    competence = referentialService.readCompetence(competenceId);
                    if (competence == null) {
                        throw new SispeaException(getText("fr.onema.sispea.jsp.admin.dataLists.error.wrongCompetence", "La compétence n'est pas en base ! ", competenceId.toString()));
                    }
                }

                lDataList.setFromExercise(fromExercise);
                lDataList.setToExercise(toExercise);
                lDataList.setCompetence(competence);
                // color icon
                lDataList.setColorCode(DataListColorType.parseFromId(colorId.shortValue()));

                // Is list activated or not
                lDataList.setActive(currentList.isActive());

                // Save list
                indicatorService.saveDataList(lDataList);

                if (selectedListId != null) {
                    addActionMessage(getText("fr.onema.sispea.jsp.admin.dataLists.message.edit", "", lDataList.getName()));
                } else {
                    addActionMessage(getText("fr.onema.sispea.jsp.admin.dataLists.message.create", "", lDataList.getName()));
                }
                selectedListId = null;
                currentList = null;
                fromExerciseId = null;
                toExerciseId = null;
                competenceId = null;
            }

        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dataLists.error.save", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        try {

            loadLists();
            loadCompetenceList();
            loadExerciseList();
            manageViewActions();


        } catch (SispeaException lEx) {
            String lMessage = getText("fr.onema.sispea.jsp.admin.dataLists.error", "", lEx.getMessage());
            logger.error(lMessage);
            addActionError(lMessage);
            lResult = Action.INPUT;
        }

        // result
        return lResult;
    }

}
