package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.IndicatorService;
import fr.onema.sispea.service.data.VPDto;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This action handles the indicators limits visualization.
 * It allows the end user to view indicators limits.
 *
 * @author CS
 */
public class IndicatorsLimitsAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    @Autowired
    protected transient IndicatorService indicatorService;

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient ExerciseService exerciseService;

//    /**
//     * the competence list
//     */
//    protected List<CompetenceDto> competences;

    protected Map<String, String> competenceList;

    /**
     * the competence to display
     */
    protected Integer competenceId;

    /**
     * List of performance indicators in session
     */
    protected Collection<IndicatorDto> piList;

    /**
     * List of descriptive indicators in session
     */
    protected Collection<IndicatorDto> diList;

    /**
     * List of performance variable
     */
    protected List<VPDto> vpList;

    /**
     * The current exercise to display VP names
     */
    protected ExerciseDto exercise;

    protected String competenceName;

    @Override
    protected String doExecute() throws Exception {

//        String out = SUCCESS;

        // Open menu according to the current JSP item.
        openMenu(MenuConstants.MENU_KEY_SEARCH_INDICATOR);

        // competence
        if (competenceId == null) {
            competenceId = CompetenceDto.COMPETENCE_DRINKING_WATER_ID;
        }

        // read competences
        List<CompetenceDto> competences = referentialService.readCompetences();

        // exercise
        exercise = exerciseService.getCurrentExercise();

        // read indicators
        // load indicators
        try {
            diList = indicatorService.readDIs(competenceId);
        } catch (SispeaException lEx) {
            diList = new ArrayList<>();
        }
        try {
            piList = indicatorService.readPIs(competenceId);
        } catch (SispeaException lEx) {
            piList = new ArrayList<>();
        }

        // init vp list
        vpList = new ArrayList<>();

        // build vp list from indicator list
        List<IndicatorDto> lIndicators = new ArrayList<>(diList);
        lIndicators.addAll(piList);
        for (IndicatorDto lIndicator : lIndicators) {
            // add vps ?
            for (VPDto lPV : lIndicator.getVpList()) {
                if (!vpList.contains(lPV)) {
                    vpList.add(lPV);
                }
            }
        }
        Collections.sort(vpList);

        competenceList = new HashMap<>();
        competenceName = null;

        if ((competenceId != null) && (competences != null)) {
            for (CompetenceDto lCompetence : competences) {
                competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
                if (lCompetence.getId().equals(competenceId)) {
                    competenceName = lCompetence.getName();
                }
            }
        }

        return SUCCESS;
    }

//    public void loadData() {
//
//        // load indicators
//        try {
//            diList = indicatorService.readDIs(competenceId);
//        } catch (SispeaException lEx) {
//            diList = new ArrayList<>();
//        }
//        try {
//            piList = indicatorService.readPIs(competenceId);
//        } catch (SispeaException lEx) {
//            piList = new ArrayList<>();
//        }
//
//        // init vp list
//        vpList = new ArrayList<>();
//
//        // build vp list from indicator list
//        List<IndicatorDto> lIndicators = new ArrayList<>(diList);
//        lIndicators.addAll(piList);
//        for (IndicatorDto lIndicator : lIndicators) {
//            // add vps ?
//            for (VPDto lPV : lIndicator.getVpList()) {
//                if (!vpList.contains(lPV)) {
//                    vpList.add(lPV);
//                }
//            }
//        }
//        Collections.sort(vpList);
//    }

    public Map<String, String> getCompetenceList() throws SispeaException {

//        //init list
//        Map<String, String> competenceList = new TreeMap<>();
//
//        // loop on competences
//        for (CompetenceDto lCompetence : competences) {
//            competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
//        }
//
//        // result
        return competenceList;
    }

    public Integer getCompetenceId() {
        return competenceId;
    }

    public void setCompetenceId(Integer pCompetenceId) {
        competenceId = pCompetenceId;
    }

    public String getCompetenceName() {
//        // init
//        competenceName = null;
//
//        if ((competenceId != null) && (competences != null)) {
//            for (CompetenceDto lCompetence : competences) {
//                if (lCompetence.getId().equals(competenceId)) {
//                    competenceName = lCompetence.getName();
//                }
//            }
//        }
//
//        // result
        return competenceName;

    }

    public Collection<IndicatorDto> getPiList() {
        return piList;
    }

    public void setPiList(Collection<IndicatorDto> pPiList) {
        piList = pPiList;
    }

    public Collection<IndicatorDto> getDiList() {
        return diList;
    }

    public void setDiList(Collection<IndicatorDto> pDiList) {
        diList = pDiList;
    }

    public List<VPDto> getVpList() {
        return vpList;
    }

    public void setVpList(List<VPDto> pVpList) {
        vpList = pVpList;
    }

    public ExerciseDto getExercise() {
        return exercise;
    }

    public void setExercise(ExerciseDto pExercise) {
        exercise = pExercise;
    }

}