package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.ldap.LDAPService;
import fr.onema.sispea.service.user.Right;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * This action handles the LDAP cleaning.
 * maitenance action
 *
 * @author CS
 */
public class CleanLDAPAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(CleanLDAPAction.class);

    @Autowired
    protected transient LDAPService ldapService;

    /**
     * Should the deletion be done ?
     */
    protected boolean doNotDelete;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug("new exercise");
        }

        // check rights
        if (!checkUserRight(Right.Manage)) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // get all login from ldap
        List<UserDto> lUsers = ldapService.findUsers();

        // build login list
        List<String> lLDAPLogins = new ArrayList<>();
        for (UserDto lUser : lUsers) {
            lLDAPLogins.add(lUser.getLogin());
        }

        // fin users in db
        List<String> lDbLogins = userService.usersExistsinDb(lLDAPLogins);

        // just keep ldap login to delete
        for (Iterator<String> iterator = lLDAPLogins.iterator(); iterator.hasNext(); ) {
            String lLdapLogin = iterator.next();
            if (lDbLogins.contains(lLdapLogin)) {
                iterator.remove();
            }
        }

        // delete users from ldap ?
        String lMsg;
        if (!doNotDelete) {
            ldapService.deleteUsersFromLogins(lLDAPLogins);
            lMsg = " deleted from LDAP";
        } else {
            lMsg = " not deleted from LDAP but should be deleted ";
        }

        // log
        for (String lLogin : lLDAPLogins) {
            addActionMessage(lLogin + lMsg);
        }

        // result
        return Action.SUCCESS;
    }

    public boolean isDoNotDelete() {
        return doNotDelete;
    }

    public void setDoNotDelete(boolean pDoNotDelete) {
        doNotDelete = pDoNotDelete;
    }

}
