package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.ExerciseDto;
import fr.onema.sispea.service.data.ExerciseService;
import fr.onema.sispea.service.data.IndicatorDto;
import fr.onema.sispea.service.data.IndicatorService;
import fr.onema.sispea.service.data.IndicatorType;
import fr.onema.sispea.service.data.SynthDisplayDto;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import fr.onema.sispea.util.constants.NumberUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * This action handles the synthesis display administration.
 *
 * @author CS
 */
public abstract class AbstractSynthDisplayAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(AbstractSynthDisplayAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient ExerciseService exerciseService;

    @Autowired
    protected transient IndicatorService indicatorService;

    /**
     * the chosen competence id
     */
    protected Integer chosenCompetenceId;

    /**
     * The competence displayed
     */
    protected CompetenceDto competence;

    /**
     * the performance indicators list
     */
    protected List<IndicatorDto> pis = new ArrayList<>();

    /**
     * the descriptive indicator list
     */
    protected List<IndicatorDto> dis = new ArrayList<>();

    /**
     * the exercise list
     */
    protected List<ExerciseDto> exercises = new ArrayList<>();

    /**
     * the competence list
     */
    protected List<CompetenceDto> competences = new ArrayList<>();

    /**
     * the synth display list
     */
    protected List<SynthDisplayDto> synthDisplays = new ArrayList<>();

    protected Map<String, String> competenceList;

//    protected Set<String> disVisible;
//
//    protected Set<String> pisVisible;

    protected Set<String> visibleIndicators;

    protected List<IndicatorDto> allIndicators;

    public boolean isIndicatorVisible(Integer pExerciseId, Integer pIndicatorId) {
        String key = pExerciseId + "_" + pIndicatorId;
        return visibleIndicators.contains(key);
    }

//    public boolean isPisVisible(Integer pExerciseId, Integer pIndicatorId) {
//        String key = pExerciseId + "_" + pIndicatorId;
//        return pisVisible.contains(key);
//    }
//
//    public boolean isDisVisible(Integer pExerciseId, Integer pIndicatorId) {
//        String key = pExerciseId + "_" + pIndicatorId;
//        return disVisible.contains(key);
//    }

    public Map<String, String> getCompetenceList() {
//
//        //init list
//        HashMap<String, String> competenceList = new HashMap<>();
//
//        if (competences != null) {
//            // add competences
//            for (CompetenceDto lCompetence : competences) {
//                competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
//            }
//        }

        return competenceList;
    }

    public List<ExerciseDto> getExerciseList() throws SispeaException {
        return exercises;
    }

    public Integer getChosenCompetenceId() {
        return chosenCompetenceId;
    }

    public void setChosenCompetenceId(Integer pChosenCompetenceId) {
        chosenCompetenceId = pChosenCompetenceId;
    }

    public List<IndicatorDto> getPis() {
        return pis;
    }

    public List<IndicatorDto> getDis() {
        return dis;
    }

    public String getEmptyMax() {
        return NumberUtils.doubleToString(IndicatorDto.EMPTY_MAX, 0, false);
    }

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("synth display");
//        }
//
//        // result
//        return Action.SUCCESS;
//
//    }

    /**
     * handles view actions
     *
     * @throws SispeaException
     */
    protected void manageViewAction() throws SispeaException {

        // load competences and check the chosen one
        checkCompetence();

        // load indicators
        loadIndicators();

        // load lists
        exercises = exerciseService.readExercises();
        synthDisplays = indicatorService.readAllSynthDisplay();

        // load visible indicators
        visibleIndicators = loadVisibleIndicators();

    }

//    /**
//     * return a list of all synthDisplay
//     *
//     * @return
//     * @throws SispeaException
//     */
//    protected List<SynthDisplayDto> loadSynthDisplays() throws SispeaException {
//        // get synthDisplays
//        return indicatorService.readAllSynthDisplay();
//    }
//
//    /**
//     * return a list of all exercises
//     *
//     * @return
//     * @throws SispeaException
//     */
//    protected List<ExerciseDto> loadExercises() throws SispeaException {
//        // get exercises
//        return exerciseService.readExercises();
//    }

//    /**
//     * return a list of all competences
//     *
//     * @return
//     * @throws SispeaException
//     */
//    protected List<CompetenceDto> loadCompetences() throws SispeaException {
//        // get competences
//        return referentialService.readCompetences();
//    }

    /**
     * check competence params
     *
     * @throws SispeaException
     */
    protected void checkCompetence() throws SispeaException {

        // load competences
        competences = referentialService.readCompetences();

        // check competence id
        if (chosenCompetenceId == null) {
            chosenCompetenceId = CompetenceDto.COMPETENCE_DRINKING_WATER_ID;
        }

        // load competence
        competence = referentialService.readCompetence(chosenCompetenceId);
        if (competence == null) {
            throw new SispeaException("fr.onema.sispea.indicatorsLimits.error.wrongCompetenceId");
        }

        competenceList = new HashMap<>();
        for (CompetenceDto lCompetence : competences) {
            competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
        }

    }

    /**
     * loads indicator
     *
     * @throws SispeaException
     */
    protected void loadIndicators() throws SispeaException {

        // load indicators
        List<IndicatorDto> dis = new ArrayList<>();
        List<IndicatorDto> pis = new ArrayList<>();
        List<IndicatorDto> lIndicators = indicatorService.readIndicators(chosenCompetenceId, null);

        // split in two list
        for (IndicatorDto lIndicator : lIndicators) {
            if (lIndicator.getType() == IndicatorType.Descriptive) {
                dis.add(lIndicator);
            } else {
                pis.add(lIndicator);
            }
        }

        // sort
        Collections.sort(dis);
        Collections.sort(pis);

        this.dis = ImmutableList.copyOf(dis);
        this.pis = ImmutableList.copyOf(pis);
        this.allIndicators = ImmutableList.<IndicatorDto>builder().addAll(dis).addAll(pis).build();

    }

    protected Set<String> loadVisibleIndicators() {

        Set<String> visibleIndicators  = new HashSet<>();

        for (ExerciseDto exercise : exercises) {

            Integer exerciseId = exercise.getId();

            String prefix = exerciseId + "_";

            for (IndicatorDto indicator : allIndicators) {
                Integer indicatorId = indicator.getId();
                boolean visible = isIndicatorVisible(synthDisplays, exerciseId, indicatorId);
                if (visible) {
                    visibleIndicators.add(prefix + indicatorId);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Visible indicator: " + exerciseId + "-" + indicatorId);
                    }
                }
            }

        }

        return ImmutableSet.copyOf(visibleIndicators);

    }

    /**
     * @param pExerciseId
     * @param pIndicatorId
     * @return true if synthesis is displayed for exercise and competence. False else.
     */
    protected boolean isIndicatorVisible(List<SynthDisplayDto> synthDisplays, Integer pExerciseId, Integer pIndicatorId) {

        // init
        boolean lRes;
        SynthDisplayDto lFound = null;

        // search for synth display
        for (Iterator<SynthDisplayDto> iterator = synthDisplays.iterator(); iterator.hasNext() && lFound == null; ) {
            SynthDisplayDto lSynthDisplay = iterator.next();
            if (lSynthDisplay.getIndicator().getId().equals(pIndicatorId)
                && lSynthDisplay.getExercise().getId().equals(pExerciseId)) {
                lFound = lSynthDisplay;
            }
        }

        // found ?
        if (lFound == null) {
            lRes = false;
        } else {
            lRes = lFound.getDisplay();
        }

        // result
        return lRes;
    }


}
