package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.data.IndicatorService;
import fr.onema.sispea.service.data.SliceLeveledDto;
import fr.onema.sispea.service.referential.CompetenceDto;
import fr.onema.sispea.service.referential.ReferentialService;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * This action handles the synthesis relevant levels administration.
 *
 * @author CS
 */
public abstract class AbstractRelevantLevelsAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(RelevantLevelsAction.class);

    @Autowired
    protected transient ReferentialService referentialService;

    @Autowired
    protected transient IndicatorService indicatorService;

    /**
     * the competence list
     */
    protected List<CompetenceDto> competences = new ArrayList<>();

    /**
     * the chosen competence id
     */
    protected Integer chosenCompetenceId;

    /**
     * The competence adisplayed
     */
    protected CompetenceDto competence;

    /**
     * Slices :
     */
    protected List<SliceLeveledDto> slices = new ArrayList<>();

    protected Map<String, String> competenceList;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("relevant levels");
//        }
//
//        // result
//        return Action.SUCCESS;
//
//    }

    /**
     * check competence params
     *
     * @throws SispeaException
     */
    protected void checkCompetence() throws SispeaException {

        // load competences
        competences = referentialService.readCompetences();

        // check competence if empty
        if (chosenCompetenceId == null) {
            chosenCompetenceId = CompetenceDto.COMPETENCE_DRINKING_WATER_ID;
        }

        // read
        competence = referentialService.readCompetence(chosenCompetenceId);
        if (competence == null) {
            throw new SispeaException("fr.onema.sispea.jsp.admin.relevantLevels.error.wrongCompetenceId");
        }

        competenceList = new HashMap<>();
        if (competences != null) {
            for (CompetenceDto lCompetence : competences) {
                competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
            }
        }

    }

    public Map<String, String> getCompetenceList() {
//        //init list
//        competenceList = new HashMap<>();
//
//        if (competences != null) {
//            // add competences
//            for (CompetenceDto lCompetence : competences) {
//                competenceList.put(lCompetence.getId().toString(), lCompetence.getName());
//            }
//        }
        return competenceList;
    }

    public List<CompetenceDto> getCompetences() {
        return competences;
    }

    public void setCompetences(List<CompetenceDto> pCompetences) {
        competences = pCompetences;
    }

    public Integer getChosenCompetenceId() {
        return chosenCompetenceId;
    }

    public void setChosenCompetenceId(Integer pChosenCompetenceId) {
        chosenCompetenceId = pChosenCompetenceId;
    }

    public CompetenceDto getCompetence() {
        return competence;
    }

    public void setCompetence(CompetenceDto pCompetence) {
        competence = pCompetence;
    }

    public List<SliceLeveledDto> getSlices() {
        return slices;
    }

    public void setSlices(List<SliceLeveledDto> pSlices) {
        slices = pSlices;
    }

}
