package fr.onema.sispea.struts.admin.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.exchange.ExchangeParameters;
import fr.onema.sispea.service.exchange.FileExchangeService;
import fr.onema.sispea.service.exchange.thread.AsynchronousService;
import fr.onema.sispea.service.exchange.thread.ProcessParameters;
import fr.onema.sispea.struts.AbstractSispeaAction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.List;

/**
 * This action handles the exchange queue actions.
 * maitenance action
 *
 * @author CS
 */
public abstract class AbstractExchangeQueueAction extends AbstractSispeaAction {

    private static final long serialVersionUID = 1L;

//    private static final Logger logger = Logger.getLogger(AbstractExchangeQueueAction.class);

    @Autowired
    protected transient FileExchangeService fileExchangeService;

    @Autowired
    @Qualifier("usersExportGeneratorService")
    protected transient AsynchronousService usersExportGeneratorService;

//    @Autowired
//    @Qualifier("speaComparatorGeneratorService")
//    protected transient AsynchronousService speaComparatorGeneratorService;

    /**
     * The exchange parameters list
     */
    protected List<ExchangeParameters> exchangeParameters;

    /**
     * The exchange parameters list
     */
    protected List<ProcessParameters> processParameters;

//    @Override
//    protected String doExecute() throws Exception {
//
//        if (logger.isDebugEnabled()) {
//            logger.debug("exchange queue action - shouldn't be called");
//        }
//
//        // check rights
//        if (!checkUserRight(Right.Manage)) {
//            // message
//            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
//        }
//
//        // open menu
//        openMenu(MenuConstants.MENU_KEY_EXCHANGESQUEUE);
//
//        // result
//        return Action.SUCCESS;
//    }

    /**
     * Check the exchange parameters and sets the exchange param list
     *
     * @throws SispeaException
     */
    protected void checkExchanges() throws SispeaException {

        // loop on exchange queue
        exchangeParameters = fileExchangeService.getExchangesParamList();

        // Search any user export
        processParameters = usersExportGeneratorService.getProcessParamList();

    }

//    /**
//     * Delete if possible the exchange corresponding to description
//     *
//     * @param pDescriptionToDelete
//     * @throws SispeaException
//     */
//    protected void deleteExchange(String pDescriptionToDelete) throws SispeaException {
//
//        // delete
//        try {
//            fileExchangeService.deleteExchange(pDescriptionToDelete);
//        } catch (SispeaException e) {
//            // We do nothing, because maybe it's a process instead...
//
//        }
//
//        try {
//            usersExportGeneratorService.deleteProcess(pDescriptionToDelete);
//        } catch (SispeaException e) {
//            // We do nothing, because maybe it's a comparator process instead...
//        }
//
//        try {
//            speaComparatorGeneratorService.deleteProcess(pDescriptionToDelete);
//        } catch (SispeaException e) {
//            // We do nothing, because maybe it's a comparator process instead...
//        }
//    }

    public List<ExchangeParameters> getExchangeParameters() {
        return exchangeParameters;
    }

    public void setExchangeParameters(List<ExchangeParameters> pExchangeParameters) {
        exchangeParameters = pExchangeParameters;
    }

    public List<ProcessParameters> getProcessParameters() {
        return processParameters;
    }

    public void setProcessParameters(List<ProcessParameters> pProcessParameters) {
        processParameters = pProcessParameters;
    }

}
