package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.MandateDto;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the user mandates visualization.
 *
 * @author CS
 */
public class UpdateUserMandatesAction extends AbstractUserMandatesAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(UpdateUserMandatesAction.class);

    /**
     * the mandator
     */
    protected String mandatorLogin;

    /**
     * the mandated
     */
    protected String mandatedLogin;

    /**
     * the spea Id
     */
    protected Integer speaId;

    /**
     * the can publish to set on mandate
     */
    protected String mandateCanPuBlish;

    @Override
    protected String doExecute() throws Exception {

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.UpdateUserMandatesAction.debug.doExecute"));
        }

        // init
        String forward = Action.SUCCESS;

        // Local Mandate
        MandateDto lMandate;

        // get auth user
        UserDto lSessionUser = getCurrentUser();

        // user must be logged
        if (lSessionUser == null) {
            // message
            throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
        }

        // set the menu
        openMenu(MenuConstants.MENU_KEY_MYMANDATES);

        try {
            // read the mandated
            lMandate = userService.readMandate(getMandatedLogin(), getSpeaId(), getMandatorLogin());

            // test can publish value
            if (mandateCanPuBlish == null) {
                throw new SispeaException(getText("fr.onema.sispea.jsp.user.showUserMandates.mandates.error.submit"));
            }

            // check can publish
            boolean lCanPublish = false;
            if (mandateCanPuBlish.equals(getText("fr.onema.sispea.jsp.user.showUserMandates.mandates.canPublish.true"))) {
                lCanPublish = true;
            }

            // set canPublish
            lMandate.setCanPublish(lCanPublish);

            // save to db
            userService.updateUserMandate(lMandate);

            // message
            addActionMessage(getText("fr.onema.sispea.jsp.user.showUserMandates.mandates.message.updated"));
        } catch (SispeaException lEx) {
            forward = Action.INPUT;
            String lMessage = getText("fr.onema.sispea.jsp.user.showUserMandates.mandates.error.general", "", getText(lEx.getMessage()));
            addActionError(lMessage);
        }

        // Do not load the mandates here.
        // Forward towards the showUserMandates action

        return forward;
    }

    public String getMandatorLogin() {
        return mandatorLogin;
    }

    public void setMandatorLogin(String pMandatorLogin) {
        mandatorLogin = pMandatorLogin;
    }

    public String getMandatedLogin() {
        return mandatedLogin;
    }

    public void setMandatedLogin(String pMandatedLogin) {
        mandatedLogin = pMandatedLogin;
    }

    public Integer getSpeaId() {
        return speaId;
    }

    public void setSpeaId(Integer pSpeaId) {
        speaId = pSpeaId;
    }

    public String getMandateCanPuBlish() {
        return mandateCanPuBlish;
    }

    public void setMandateCanPuBlish(String pMandateCanPuBlish) {
        mandateCanPuBlish = pMandateCanPuBlish;
    }

}
