package fr.onema.sispea.struts.user.action;

/*
 * #%L
 * SISPEA web application
 * %%
 * Copyright (C) 2014 - 2015 ONEMA
 * %%
 * ONEMA - Tous droits réservés
 * #L%
 */


import com.opensymphony.xwork2.Action;
import fr.onema.sispea.SispeaException;
import fr.onema.sispea.service.user.UserDto;
import fr.onema.sispea.struts.common.menu.MenuConstants;
import org.apache.log4j.Logger;

/**
 * This action handles the user mandates visualization.
 *
 * @author CS
 */
public class ShowUserMandatesAction extends AbstractUserMandatesAction {

    private static final long serialVersionUID = 1L;

    private static final Logger logger = Logger.getLogger(ShowUserMandatesAction.class);

    /**
     * The user for which the mandates should be shown.
     */
    protected UserDto userToDisplay;

    /**
     * Output: True if the current user can edit the mandate properties.<br />
     * A user can only edit its own properties. Even the general administrator cannot edit
     * the mandates of other users.
     */
    protected boolean canEdit;

    @Override
    protected String doExecute() throws Exception {

        // The user for which the mandates should be shown
        userToDisplay = null;

        if (logger.isDebugEnabled()) {
            logger.debug(getText("fr.onema.sispea.struts.user.action.ShowUserMandatesAction.debug.doExecute"));
        }

        canEdit = false;

        // Do we have an user as input ?
        if (userLogin == null || "".equals(userLogin)) {

            // Use the current user
            userToDisplay = getCurrentUser();

            // The current user may edit his own mandate properties
            canEdit = true;

            // The user must be logged in
            if (userToDisplay == null || (userToDisplay.getLogin() == null) || (userToDisplay.getLogin().length() == 0)) {
                // message
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }

            // Highlight the current menu item
            openMenu(MenuConstants.MENU_KEY_MYMANDATES);
        } else {
            // The current user must be a general administrator
            UserDto sessionUser = getCurrentUser();

            if (!sessionUser.isGeneralAdmin()) {
                throw new SispeaException("fr.onema.sispea.autentication.notAllowed");
            }

            // Load the requested user
            userToDisplay = userService.readUser(userLogin);

            // Highlight the current menu item
            openMenu(MenuConstants.MENU_KEY_SEE_MANDATES);
        }

        // Show the mandates
        showMandates(userToDisplay);

        return Action.SUCCESS;

    }

    /**
     * Reads the mandates associated to the user pUser.
     *
     * @param pUser the user for which the mandates should be shown.
     * @throws SispeaException
     */
    protected void showMandates(UserDto pUser) throws SispeaException {

        // Read the mandates the current user has given to others
        // Count given mandates
        mandatorInfo.getPaging().setResultCount(userService.countMandatesWhereMandator(pUser));
        if (mandatorInfo.getPaging().getGoToPage() != -1) {
            mandatorInfo.getPaging().setPageOffset(mandatorInfo.getPaging().getGoToPage() - 1);
        }

        int mandatorStartIndex = mandatorInfo.getPaging().getStartIndex() * mandatorInfo.getPaging().getPageSize();
        int mandatorResultSize = mandatorInfo.getPaging().getPageSize();
        mandatesWhereMandator = userService.readMandatesWhereMandator(pUser, true, true,
                                                                      mandatorStartIndex,
                                                                      mandatorResultSize,
                                                                      mandatorInfo.getSortCriterion(),
                                                                      mandatorInfo.getSortDirection());


        // Read the mandates the current user has received
        // Count received mandates
        mandatedInfo.getPaging().setResultCount(userService.countMandatesWhereMandated(pUser));
        if (mandatedInfo.getPaging().getGoToPage() != -1) {
            mandatedInfo.getPaging().setPageOffset(mandatedInfo.getPaging().getGoToPage() - 1);
        }

        int mandatedStartIndex = mandatedInfo.getPaging().getStartIndex() * mandatedInfo.getPaging().getPageSize();
        int mandatedResultSize = mandatedInfo.getPaging().getPageSize();

        mandatesWhereMandated = userService.readMandatesWhereMandated(pUser, true, true,
                                                                      mandatedStartIndex,
                                                                      mandatedResultSize,
                                                                      mandatedInfo.getSortCriterion(),
                                                                      mandatedInfo.getSortDirection());

    }

    public boolean isCanEdit() {
        return canEdit;
    }

    public UserDto getUserToDisplay() {
        return userToDisplay;
    }

}
